/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SmartAnonMarshaler {
    SmartAnonMarshaler() {
    }

    public static Object marshal(Object obj) {
        if (SmartAnonMarshaler.isAnonObject(obj)) {
            return new AnonEnvelop(obj);
        }
        return obj;
    }

    public static Object unmarshal(Object obj) throws IOException {
        if (obj instanceof AnonEnvelop) {
            return ((AnonEnvelop)obj).unmarshal();
        }
        return obj;
    }

    private static boolean isAnonObject(Object obj) {
        return obj != null && !(obj instanceof Serializable) && obj.getClass().isAnonymousClass();
    }

    public static class AnonEnvelop
    implements Serializable {
        private static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS = new HashMap();
        private Class<?> type;
        private Map<String, Object> fields;

        public AnonEnvelop(Object instance) {
            this.snapshot(instance);
        }

        private void snapshot(Object instance) {
            try {
                Field[] ff;
                this.type = instance.getClass();
                this.fields = new HashMap<String, Object>();
                for (Field f : ff = this.collectFields(this.type)) {
                    if (!this.isPersistent(f)) continue;
                    f.setAccessible(true);
                    this.fields.put(f.getName(), f.get(instance));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot capture object state", e);
            }
        }

        public Object unmarshal() throws IOException {
            Constructor<?> c = this.type.getDeclaredConstructors()[0];
            c.setAccessible(true);
            Object[] params = new Object[c.getParameterTypes().length];
            for (int i = 0; i != params.length; ++i) {
                Class<?> p = c.getParameterTypes()[i];
                params[i] = PRIMITIVE_DEFAULTS.get(p);
            }
            try {
                Field[] ff;
                Object oo = c.newInstance(params);
                for (Field f : ff = this.collectFields(this.type)) {
                    if (!this.isPersistent(f) || !this.fields.containsKey(f.getName())) continue;
                    f.setAccessible(true);
                    Object v = this.fields.get(f.getName());
                    f.set(oo, v);
                }
                return oo;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        private boolean isPersistent(Field f) {
            return !f.getName().startsWith("this$") && !Modifier.isStatic(f.getModifiers()) && !Modifier.isTransient(f.getModifiers());
        }

        private Field[] collectFields(Class<?> c) {
            ArrayList<Field> result = new ArrayList<Field>();
            this.collectFields(result, c);
            return result.toArray(new Field[result.size()]);
        }

        private void collectFields(List<Field> result, Class<?> c) {
            Class<?> s = c.getSuperclass();
            if (s != Object.class) {
                this.collectFields(result, s);
            }
            for (Field f : c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                result.add(f);
            }
        }

        static {
            PRIMITIVE_DEFAULTS.put(Boolean.TYPE, Boolean.FALSE);
            PRIMITIVE_DEFAULTS.put(Byte.TYPE, (byte)0);
            PRIMITIVE_DEFAULTS.put(Short.TYPE, (short)0);
            PRIMITIVE_DEFAULTS.put(Character.TYPE, Character.valueOf('\u0000'));
            PRIMITIVE_DEFAULTS.put(Integer.TYPE, 0);
            PRIMITIVE_DEFAULTS.put(Long.TYPE, 0L);
            PRIMITIVE_DEFAULTS.put(Float.TYPE, Float.valueOf(0.0f));
            PRIMITIVE_DEFAULTS.put(Double.TYPE, 0.0);
        }
    }
}

