/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.gridkit.util.concurrent.FutureBox;
import org.gridkit.util.concurrent.FutureEx;
import org.gridkit.zerormi.RemoteInstance;
import org.gridkit.zerormi.RmiChannel;

public class RemoteStub
implements InvocationHandler {
    private RemoteInstance identity;
    private RmiChannel channel;

    public RemoteStub(RemoteInstance identity, RmiChannel channel) {
        this.identity = identity;
        this.channel = channel;
    }

    public RemoteInstance getRemoteInstance() {
        return this.identity;
    }

    public RmiChannel getRmiChannel() {
        return this.channel;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        return this.channel.remoteInvocation(this, proxy, method, args);
    }

    public FutureEx<Object> asyncInvoke(Object proxy, Method method, Object[] args) {
        if (method.getDeclaringClass() == Object.class) {
            FutureBox box = new FutureBox();
            try {
                box.setData(method.invoke((Object)this, args));
            }
            catch (IllegalAccessException e) {
                box.setError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                box.setError(e.getCause());
            }
            return box;
        }
        return this.channel.asyncRemoteInvocation(this, proxy, method, args);
    }

    public static Object buildProxy(RemoteInstance remoteInstance, RmiChannel channel) throws ClassNotFoundException {
        String[] classNames = remoteInstance.interfaces;
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i != classNames.length; ++i) {
            classes[i] = channel.classForName(classNames[i]);
        }
        return Proxy.newProxyInstance(channel.getClassLoader(), classes, (InvocationHandler)new RemoteStub(remoteInstance, channel));
    }

    public static boolean isRemoteStub(Object proxy) {
        return Proxy.isProxyClass(proxy.getClass()) && Proxy.getInvocationHandler(proxy) instanceof RemoteStub;
    }

    public static <T> FutureEx<T> remoteSubmit(Object proxy, Method method, Object ... arguments) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        if (handler instanceof RemoteStub) {
            RemoteStub stub = (RemoteStub)handler;
            return stub.asyncInvoke(proxy, method, arguments);
        }
        throw new IllegalArgumentException("Not a remote proxy");
    }

    public String toString() {
        return this.identity.toString();
    }
}

