/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;

public class RemoteMethodSignature
implements Serializable {
    private static final long serialVersionUID = 20080415L;
    private String className;
    private String methodName;
    private String[] methodSignature;

    public RemoteMethodSignature(Method method) {
        this(method.getDeclaringClass().getName(), method.getName(), RemoteMethodSignature.toClassNames(method.getParameterTypes()));
    }

    public RemoteMethodSignature(String className, String methodName, String[] methodSignature) {
        this.className = className;
        this.methodName = methodName;
        this.methodSignature = methodSignature;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getMethodSignature() {
        return this.methodSignature;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteMethodSignature other = (RemoteMethodSignature)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return Arrays.equals(this.methodSignature, other.methodSignature);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + Arrays.hashCode(this.methodSignature);
        return result;
    }

    private static String[] toClassNames(Class[] classes) {
        String[] names = new String[classes.length];
        for (int i = 0; i != classes.length; ++i) {
            names[i] = classes[i].getName();
        }
        return names;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.className).append('#').append(this.methodName);
        buf.append("(");
        for (String arg : this.methodSignature) {
            int p = arg.lastIndexOf(46);
            if (p > 0) {
                arg = arg.substring(p + 1);
            }
            buf.append(arg).append(",");
        }
        if (buf.charAt(buf.length() - 1) == ',') {
            buf.setCharAt(buf.length() - 1, ')');
        } else {
            buf.append(')');
        }
        return buf.toString();
    }
}

