/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.gridkit.util.concurrent.AdvancedExecutor;
import org.gridkit.util.concurrent.FutureEx;
import org.gridkit.zerormi.RemoteExecutor;
import org.gridkit.zerormi.RemoteStub;

public class RemoteExecutorAsynAdapter
implements AdvancedExecutor {
    private static final Method EXEC_RUNNABLE = RemoteExecutorAsynAdapter.getExec(Runnable.class);
    private static final Method EXEC_CALLABLE = RemoteExecutorAsynAdapter.getExec(Callable.class);
    private RemoteExecutor executor;

    private static Method getExec(Class<?> c) {
        try {
            return RemoteExecutor.class.getMethod("exec", c);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RemoteExecutorAsynAdapter(RemoteExecutor executor) {
        if (!RemoteStub.isRemoteStub(executor)) {
            throw new IllegalArgumentException("Not a remote proxy");
        }
        this.executor = executor;
    }

    public void execute(Runnable task) {
        throw new UnsupportedOperationException("This method doesn't make sense for remote execution");
    }

    public void exec(Runnable task) throws Exception {
        this.executor.exec(task);
    }

    public <T> T exec(Callable<T> task) throws Exception {
        return this.executor.exec(task);
    }

    public FutureEx<Void> submit(Runnable task) {
        return RemoteStub.remoteSubmit(this.executor, EXEC_RUNNABLE, task);
    }

    public <V> FutureEx<V> submit(Callable<V> task) {
        return RemoteStub.remoteSubmit(this.executor, EXEC_CALLABLE, task);
    }
}

