/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;

class IOHelper {
    private static char[] HEX = "0123456789ABCDEF".toCharArray();

    IOHelper() {
    }

    public static boolean isSocketTerminationException(Exception e) {
        if (e instanceof EOFException) {
            return true;
        }
        if (e.getClass() == IOException.class) {
            if ("pipe is closed by reader".equals(e.getMessage().toLowerCase())) {
                return true;
            }
            if ("pipe is closed by writer".equals(e.getMessage().toLowerCase())) {
                return true;
            }
        } else if (e instanceof SocketException) {
            if ("connection reset".equals(e.getMessage().toLowerCase())) {
                return true;
            }
            if ("socket closed".equals(e.getMessage().toLowerCase())) {
                return true;
            }
        }
        return false;
    }

    public static String toHexString(byte[] data, int offs, int len) {
        char[] c = new char[3 * len];
        for (int i = 0; i != len; ++i) {
            c[3 * i] = HEX[0xF & data[offs + i] >> 4];
            c[3 * i + 1] = HEX[0xF & data[offs + i]];
            c[3 * i + 2] = 32;
        }
        return new String(c, 0, c.length - 1);
    }
}

