/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi;

import java.io.IOException;
import java.io.OutputStream;
import org.gridkit.zerormi.IOHelper;

public class EnvelopOutputStream
extends OutputStream {
    private static boolean DEBUG = false;
    private OutputStream target;
    private byte[] buffer = new byte[4096];
    private int offs = 0;

    public EnvelopOutputStream(OutputStream target) {
        this.target = target;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.remaining() > 0) {
            this.buffer[this.offs++] = (byte)b;
        }
    }

    protected int remaining() throws IOException {
        int r = this.buffer.length - this.offs;
        if (r == 0) {
            this.flush();
            return this.remaining();
        }
        return r;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int r;
        int roff = off;
        for (int rlen = len; rlen > 0; rlen -= r) {
            r = this.remaining();
            if (r >= rlen) {
                System.arraycopy(b, roff, this.buffer, this.offs, rlen);
                this.offs += rlen;
                return;
            }
            System.arraycopy(b, roff, this.buffer, this.offs, r);
            this.offs += r;
            roff += r;
        }
    }

    public void closeMessage() throws IOException {
        this.flush();
        this.writeShort(0);
        if (DEBUG) {
            System.out.println("[OUT:" + this.hashCode() + "] - EOM");
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.offs > 0) {
            this.writeShort(this.offs);
            this.target.write(this.buffer, 0, this.offs);
            if (DEBUG) {
                System.out.println("[OUT:" + this.hashCode() + "] - " + this.offs + "| " + IOHelper.toHexString(this.buffer, 0, this.offs));
            }
            this.offs = 0;
        }
    }

    void writeShort(int v) throws IOException {
        this.target.write(v >>> 8 & 0xFF);
        this.target.write(v >>> 0 & 0xFF);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.target.close();
    }
}

