/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zerormi;

import java.io.IOException;
import java.io.InputStream;
import org.gridkit.zerormi.IOHelper;

class EnvelopInputStream
extends InputStream {
    private static boolean DEBUG = false;
    private InputStream source;
    private byte[] buffer = new byte[4096];
    private int offs = 0;
    private int lim = 0;
    private boolean eom;

    public EnvelopInputStream(InputStream in) {
        this.source = in;
    }

    private int remaining() throws IOException {
        if (this.offs < this.lim) {
            return this.lim - this.offs;
        }
        if (this.eom) {
            return 0;
        }
        int chunk = this.readShort();
        if (chunk == -1) {
            this.eom = true;
            return 0;
        }
        if (chunk == 0) {
            if (DEBUG) {
                System.out.println("[IN:" + this.hashCode() + "] - EOM");
            }
            this.eom = true;
            return 0;
        }
        if (chunk < 0 || chunk > this.buffer.length) {
            throw new IOException("Stream corrupted! Illegal chunk size " + chunk);
        }
        this.offs = 0;
        this.lim = chunk;
        this.readBuffer();
        return this.lim - this.offs;
    }

    int readShort() throws IOException {
        int ch1 = this.source.read();
        if (ch1 == -1) {
            return -1;
        }
        int ch2 = this.source.read();
        if ((ch1 | ch2) < 0) {
            throw new IOException("Stream trunkated");
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    private void readBuffer() throws IOException {
        int n;
        for (int rp = 0; rp < this.lim; rp += n) {
            n = this.source.read(this.buffer, rp, this.lim - rp);
            if (n >= 0) continue;
            throw new IOException("Stream truncated");
        }
        if (DEBUG) {
            System.out.println("[IN:" + this.hashCode() + "] - " + this.lim + "| " + IOHelper.toHexString(this.buffer, 0, this.lim));
        }
    }

    public void nextMessage() throws IOException {
        this.skip(Long.MAX_VALUE);
        this.eom = false;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining() > 0) {
            return this.buffer[this.offs++];
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining() == 0) {
            return -1;
        }
        int rlen = len;
        int roff = off;
        int r;
        while ((r = this.remaining()) != 0) {
            if (r >= rlen) {
                System.arraycopy(this.buffer, this.offs, b, roff, rlen);
                this.offs += rlen;
                return len;
            }
            System.arraycopy(this.buffer, this.offs, b, roff, r);
            roff += r;
            rlen -= r;
            this.offs += r;
        }
        return len - rlen;
    }

    @Override
    public long skip(long n) throws IOException {
        long sr = n;
        int r;
        while ((r = this.remaining()) != 0) {
            if ((long)r >= sr) {
                this.offs = (int)((long)this.offs + sr);
                return 0L;
            }
            sr -= (long)r;
            this.offs = this.lim;
        }
        return n - sr;
    }
}

