/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zeroio;

import java.io.IOException;
import java.io.OutputStream;

public class LookbackOutputStream
extends OutputStream {
    private OutputStream sink;
    private byte[] buffer;
    private int start;
    private int end;
    private long byteCounter;
    private volatile boolean closed;
    private volatile boolean clean = true;

    public LookbackOutputStream(int bufferSize) {
        this.buffer = new byte[bufferSize];
    }

    public synchronized byte[] getLookbackBuffer() {
        byte[] bb = new byte[(int)Math.min((long)this.buffer.length, this.byteCounter)];
        for (int i = 0; i != bb.length; ++i) {
            bb[bb.length - i - 1] = this.buffer[(this.buffer.length + this.end - i - 1) % this.buffer.length];
        }
        return bb;
    }

    public synchronized long getWrittenBytes() {
        return this.byteCounter;
    }

    public synchronized OutputStream getOutput() {
        return this.sink;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void setOutput(OutputStream os) throws IOException {
        this.sink = os;
        this.pump();
        if (this.closed) {
            this.sink.close();
        }
    }

    protected int size() {
        return (this.buffer.length + this.end - this.start) % this.buffer.length;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.size() > this.buffer.length / 2) {
            this.pump();
        }
        this.buffer[this.end] = (byte)b;
        this.end = (this.end + 1) % this.buffer.length;
        if (this.end == this.start) {
            this.start = (this.start + 1) % this.buffer.length;
        }
        ++this.byteCounter;
        this.clean = false;
    }

    private synchronized void pump() throws IOException {
        if (this.sink != null && this.size() > 0) {
            if (this.end >= this.start) {
                this.sink.write(this.buffer, this.start, this.end - this.start);
                this.start = this.end;
            } else {
                this.sink.write(this.buffer, this.start, this.buffer.length - this.start);
                this.sink.write(this.buffer, 0, this.end);
                this.start = this.end;
            }
        }
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i != len; ++i) {
            this.write(b[off + i]);
        }
        this.pump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.clean) {
            return;
        }
        LookbackOutputStream lookbackOutputStream = this;
        synchronized (lookbackOutputStream) {
            if (this.sink != null) {
                this.clean = true;
                this.pump();
                this.sink.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        LookbackOutputStream lookbackOutputStream = this;
        synchronized (lookbackOutputStream) {
            if (this.sink != null) {
                this.closed = true;
                this.flush();
                this.sink.close();
            }
        }
    }
}

