/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.zeroio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractLineProcessingOutputStream
extends OutputStream {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    private void dumpBuffer() throws IOException {
        this.processLine(this.buffer.toByteArray());
        this.buffer.reset();
    }

    protected abstract void processLine(byte[] var1) throws IOException;

    @Override
    public synchronized void write(int c) throws IOException {
        this.buffer.write(c);
        if (c == 10) {
            this.dumpBuffer();
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i != len; ++i) {
            if (b[off + i] != 10) continue;
            this.writeByChars(b, off, len);
            return;
        }
        this.buffer.write(b, off, len);
    }

    private void writeByChars(byte[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i != len; ++i) {
            this.write(cbuf[off + i]);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        super.flush();
        if (this.buffer.size() > 0) {
            this.dumpBuffer();
        }
    }
}

