/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.gridkit.internal.com.jcraft.jsch.ChannelExec;
import org.gridkit.internal.com.jcraft.jsch.JSchException;
import org.gridkit.internal.com.jcraft.jsch.Session;
import org.gridkit.util.concurrent.AdvancedExecutor;
import org.gridkit.util.concurrent.FutureBox;
import org.gridkit.util.concurrent.FutureEx;
import org.gridkit.vicluster.telecontrol.BackgroundStreamDumper;
import org.gridkit.vicluster.telecontrol.Classpath;
import org.gridkit.vicluster.telecontrol.ClasspathUtils;
import org.gridkit.vicluster.telecontrol.ExecCommand;
import org.gridkit.vicluster.telecontrol.FileBlob;
import org.gridkit.vicluster.telecontrol.JvmConfig;
import org.gridkit.vicluster.telecontrol.ManagedProcess;
import org.gridkit.vicluster.telecontrol.StreamCopyService;
import org.gridkit.vicluster.telecontrol.bootstraper.Bootstraper;
import org.gridkit.vicluster.telecontrol.bootstraper.Tunneller;
import org.gridkit.vicluster.telecontrol.bootstraper.TunnellerConnection;
import org.gridkit.vicluster.telecontrol.ssh.LoggerPrintStream;
import org.gridkit.vicluster.telecontrol.ssh.RemoteFileCache;
import org.gridkit.vicluster.telecontrol.ssh.RemoteJmvReplicator;
import org.gridkit.vicluster.telecontrol.ssh.SftFileCache;
import org.gridkit.vicluster.telecontrol.ssh.SimpleSshSessionProvider;
import org.gridkit.vicluster.telecontrol.ssh.SshRemotingConfig;
import org.gridkit.vicluster.telecontrol.ssh.StreamHelper;
import org.gridkit.zerormi.DuplexStream;
import org.gridkit.zerormi.NamedStreamPair;
import org.gridkit.zerormi.hub.LegacySpore;
import org.gridkit.zerormi.hub.RemotingHub;
import org.gridkit.zerormi.hub.SlaveSpore;
import org.gridkit.zerormi.zlog.LogLevel;
import org.gridkit.zerormi.zlog.ZLogFactory;
import org.gridkit.zerormi.zlog.ZLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnellerJvmReplicator
implements RemoteJmvReplicator {
    private static final long DEFAULT_CONN_TIMEOUT = 5000L;
    private final StreamCopyService streamCopyService;
    private SshRemotingConfig rconfig = new SshRemotingConfig();
    private boolean initialized;
    private boolean destroyed;
    private Session session;
    private RemotingHub hub;
    private TunnellerConnection control;
    private RemoteFileCache jarCache;
    private String tunnellerJarPath;
    private String tunnelHost;
    private int tunnelPort;
    private long connectTimeoutMS = 5000L;
    private ZLogger logger;

    public TunnellerJvmReplicator(StreamCopyService streamCopyService) {
        this.streamCopyService = streamCopyService;
    }

    public TunnellerJvmReplicator(StreamCopyService streamCopyService, ZLogger logger) {
        this(streamCopyService);
        this.logger = logger;
    }

    @Override
    public synchronized void configure(Map<String, String> nodeConfig) {
        this.rconfig.configure(nodeConfig);
        this.rconfig.validate();
    }

    @Override
    public synchronized String getFingerPrint() {
        return this.rconfig.getFingerPrint();
    }

    @Override
    public synchronized void init() throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        if (this.logger == null) {
            this.logger = ZLogFactory.getDefaultRootLogger().getLogger(this.getClass().getSimpleName() + "." + this.rconfig.getHost());
        }
        this.initialized = true;
        try {
            SimpleSshSessionProvider sf = new SimpleSshSessionProvider();
            sf.setUser(this.rconfig.getAccount());
            if (this.rconfig.getPassword() != null) {
                sf.setPassword(this.rconfig.getPassword());
            }
            if (this.rconfig.getKeyFile() != null) {
                sf.setKeyFile(this.rconfig.getKeyFile());
            }
            if (this.rconfig.getAuthMethods() != null) {
                sf.setConfig("PreferredAuthentications", this.rconfig.getAuthMethods());
            }
            this.session = sf.getSession(this.rconfig.getHost(), this.rconfig.getAccount());
            this.jarCache = new SftFileCache(this.session, this.rconfig.getJarCachePath(), false, 4);
            this.initRemoteClasspath();
            this.startTunneler();
            this.hub = new RemotingHub(this.logger);
            this.initPortForwarding();
        }
        catch (Exception e) {
            this.destroyed = true;
            if (this.session != null) {
                try {
                    this.session.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private void initRemoteClasspath() throws IOException {
        List classpath = Classpath.getClasspath((ClassLoader)Thread.currentThread().getContextClassLoader());
        ArrayList uploadJars = new ArrayList(classpath);
        Collections.shuffle(uploadJars);
        List<String> rnames = this.jarCache.upload(uploadJars);
        HashMap<String, String> pathMap = new HashMap<String, String>();
        for (int i = 0; i != rnames.size(); ++i) {
            pathMap.put(((Classpath.ClasspathEntry)uploadJars.get(i)).getUrl().toString(), rnames.get(i));
        }
        StringBuilder remoterClasspath = new StringBuilder();
        for (Classpath.ClasspathEntry ce : classpath) {
            if (remoterClasspath.length() > 0) {
                remoterClasspath.append(' ');
            }
            remoterClasspath.append((String)pathMap.get(ce.getUrl().toString()));
        }
        Manifest mf = new Manifest();
        mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mf.getMainAttributes().put(Attributes.Name.CLASS_PATH, remoterClasspath.toString());
        mf.getMainAttributes().put(Attributes.Name.MAIN_CLASS, Tunneller.class.getName());
        byte[] tunnelerJar = ClasspathUtils.createManifestJar((Manifest)mf);
        this.tunnellerJarPath = this.jarCache.upload(new ByteBlob("tunneller.jar", tunnelerJar));
    }

    private String createBootJar(String name, JvmConfig config) throws IOException {
        List classpath = Classpath.getClasspath((ClassLoader)Thread.currentThread().getContextClassLoader());
        classpath = config.filterClasspath(classpath);
        ArrayList uploadJars = new ArrayList(classpath);
        Collections.shuffle(uploadJars);
        List<String> rnames = this.jarCache.upload(uploadJars);
        HashMap<String, String> pathMap = new HashMap<String, String>();
        for (int i = 0; i != rnames.size(); ++i) {
            pathMap.put(((Classpath.ClasspathEntry)uploadJars.get(i)).getUrl().toString(), rnames.get(i));
        }
        StringBuilder remoterClasspath = new StringBuilder();
        for (Classpath.ClasspathEntry ce : classpath) {
            if (remoterClasspath.length() > 0) {
                remoterClasspath.append(' ');
            }
            remoterClasspath.append((String)pathMap.get(ce.getUrl().toString()));
        }
        Manifest mf = new Manifest();
        mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mf.getMainAttributes().put(Attributes.Name.CLASS_PATH, remoterClasspath.toString());
        mf.getMainAttributes().put(Attributes.Name.MAIN_CLASS, Bootstraper.class.getName());
        byte[] bootJar = ClasspathUtils.createManifestJar((Manifest)mf);
        String bootJarPath = this.jarCache.upload(new ByteBlob(this.makeBootJarName(name), bootJar));
        return bootJarPath;
    }

    private String makeBootJarName(String name) {
        return "booter.jar";
    }

    private void verifyJavaVersion() throws JSchException, IOException {
        ChannelExec exec = (ChannelExec)this.session.openChannel("exec");
        String cmd = this.rconfig.getJavaExec() + " -Xms32m -Xmx32m -version";
        exec.setCommand(cmd);
        InputStream cin = exec.getInputStream();
        InputStream cerr = exec.getErrStream();
        OutputStream cout = exec.getOutputStream();
        LoggerPrintStream out = new LoggerPrintStream(this.logger.get("diag", LogLevel.WARN));
        exec.setPty(false);
        exec.connect();
        cout.close();
        long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(30L);
        byte[] buf = new byte[4096];
        while (deadline > System.nanoTime()) {
            int n;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (cout != null) {
                cout.close();
            }
            if (cin != null) {
                do {
                    if ((n = BackgroundStreamDumper.pullStream((byte[])buf, (InputStream)cin, (OutputStream)out)) >= 0) continue;
                    cin = null;
                    break;
                } while (n != 0);
            }
            if (cerr != null) {
                do {
                    if ((n = BackgroundStreamDumper.pullStream((byte[])buf, (InputStream)cerr, (OutputStream)out)) >= 0) continue;
                    cerr = null;
                    break;
                } while (n != 0);
            }
            if (cin != null || cerr != null) continue;
            int excode = exec.getExitStatus();
            exec.disconnect();
            if (excode != 0) {
                throw new RuntimeException("Failed to execute \"" + cmd + "\", host: " + this.rconfig.getAccount() + "@" + this.rconfig.getHost());
            }
            return;
        }
        throw new RuntimeException("Timedout executing \"" + cmd + "\", host: " + this.rconfig.getAccount() + "@" + this.rconfig.getHost());
    }

    private void startTunneler() throws JSchException, IOException {
        this.verifyJavaVersion();
        ChannelExec exec = (ChannelExec)this.session.openChannel("exec");
        String cmd = this.rconfig.getJavaExec() + " -Xms32m -Xmx32m -jar " + this.tunnellerJarPath;
        exec.setCommand(cmd);
        InputStream cin = exec.getInputStream();
        OutputStream cout = exec.getOutputStream();
        LoggerPrintStream tunnel = new LoggerPrintStream(this.logger.get("console", LogLevel.WARN));
        this.streamCopyService.link(exec.getExtInputStream(), (OutputStream)tunnel, false);
        exec.setPty(false);
        exec.connect();
        LoggerPrintStream diagLog = new LoggerPrintStream(this.logger.get("console", LogLevel.WARN));
        try {
            this.control = new TunnellerConnection(this.rconfig.getHost(), cin, cout, (PrintStream)diagLog, this.connectTimeoutMS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.killAndDrop(exec);
            throw new IOException("Connection aborted due to thread interrupt");
        }
        catch (TimeoutException e) {
            throw new IOException("Tunneller connection timeout");
        }
    }

    private void killAndDrop(ChannelExec exec) {
        try {
            exec.sendSignal("KILL");
        }
        catch (Exception exception) {
            // empty catch block
        }
        exec.disconnect();
    }

    protected Logger createTunnellerOutputLogger() {
        String loggerName = this.getClass().getSimpleName() + ".out." + this.getShortHostName(this.rconfig.getHost());
        return LoggerFactory.getLogger((String)loggerName);
    }

    private String getShortHostName(String host) {
        int n = host.indexOf(46);
        return n < 0 ? host : host.substring(0, n);
    }

    private void initPortForwarding() throws InterruptedException, ExecutionException, IOException {
        final FutureBox box = new FutureBox();
        this.control.newSocket(new TunnellerConnection.SocketHandler(){

            public void bound(String host, int port) {
                TunnellerJvmReplicator.this.logger.info().log("Remote port bound " + host + ":" + port);
                TunnellerJvmReplicator.this.tunnelHost = host;
                TunnellerJvmReplicator.this.tunnelPort = port;
                box.setData(null);
            }

            public void accepted(String rhost, int rport, InputStream soIn, OutputStream soOut) {
                TunnellerJvmReplicator.this.logger.info().log("Inbound connection");
                TunnellerJvmReplicator.this.handleInbound(rhost, rport, soIn, soOut);
            }
        });
        try {
            box.get(15000L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Failed to bind remote port due to timeout");
        }
    }

    protected void handleInbound(String rhost, int rport, InputStream soIn, OutputStream soOut) {
        String sname = "localhost".equals(rhost) ? "TUNNEL[" + this.rconfig.getHost() + "/*:" + rport + "]" : "TUNNEL[" + this.rconfig.getHost() + "/" + rhost + ":" + rport + "]";
        NamedStreamPair ds = new NamedStreamPair(sname, soIn, soOut);
        this.hub.dispatch((DuplexStream)ds);
    }

    private synchronized void ensureActive() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.destroyed) {
            throw new IllegalStateException("Terminated");
        }
    }

    public ManagedProcess createProcess(String caption, JvmConfig jvmArgs) throws IOException {
        this.ensureActive();
        String bootJarPath = this.createBootJar(caption, jvmArgs);
        ExecCommand jvmCmd = new ExecCommand(this.rconfig.getJavaExec());
        jvmArgs.apply(jvmCmd);
        jvmCmd.addArg("-jar").addArg(bootJarPath);
        RemoteControlSession session = new RemoteControlSession();
        String sessionId = LegacySpore.uidOf((SlaveSpore)this.hub.allocateSession(caption, (RemotingHub.SessionEventListener)session));
        jvmCmd.addArg(sessionId).addArg(this.tunnelHost).addArg(String.valueOf(this.tunnelPort));
        session.setSessionId(sessionId);
        this.exec(jvmCmd, session);
        try {
            session.started.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted");
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
        return session;
    }

    protected void exec(ExecCommand jvmCmd, RemoteControlSession handler) throws IOException {
        handler.execId = this.control.exec(jvmCmd.getWorkDir(), jvmCmd.getCommandArray(), jvmCmd.getEviroment(), (TunnellerConnection.ExecHandler)handler);
    }

    @Override
    public synchronized void dispose() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.hub.dropAllSessions();
            this.session.disconnect();
            this.hub = null;
            this.session = null;
        }
    }

    static class ByteBlob
    implements FileBlob {
        private String filename;
        private String hash;
        private byte[] data;

        public ByteBlob(String filename, byte[] data) {
            this.filename = filename;
            this.data = data;
            this.hash = StreamHelper.digest(data, "SHA-1");
        }

        public File getLocalFile() {
            return null;
        }

        public String getFileName() {
            return this.filename;
        }

        public String getContentHash() {
            return this.hash;
        }

        public InputStream getContent() {
            return new ByteArrayInputStream(this.data);
        }

        public long size() {
            return this.data.length;
        }
    }

    static class ProcessProxy
    extends Process
    implements TunnellerConnection.ExecHandler {
        protected FutureBox<Void> started = new FutureBox();
        protected FutureBox<Integer> exitCode = new FutureBox();
        protected OutputStream stdIn;
        protected InputStream stdOut;
        protected InputStream stdErr;

        ProcessProxy() {
        }

        public void started(OutputStream stdIn, InputStream stdOut, InputStream stdErr) {
            this.stdIn = stdIn;
            this.stdOut = stdOut;
            this.stdErr = stdErr;
            this.started.setData(null);
        }

        public void finished(int exitCode) {
            this.exitCode.setData((Object)exitCode);
        }

        @Override
        public OutputStream getOutputStream() {
            return this.stdIn;
        }

        @Override
        public InputStream getInputStream() {
            return this.stdOut;
        }

        @Override
        public InputStream getErrorStream() {
            return this.stdErr;
        }

        @Override
        public int waitFor() throws InterruptedException {
            try {
                return (Integer)this.exitCode.get();
            }
            catch (ExecutionException e) {
                throw new Error("Impossible");
            }
        }

        @Override
        public int exitValue() {
            if (this.exitCode.isDone()) {
                try {
                    return (Integer)this.exitCode.get();
                }
                catch (InterruptedException e) {
                    throw new Error("Impossible");
                }
                catch (ExecutionException e) {
                    throw new Error("Impossible");
                }
            }
            throw new IllegalThreadStateException();
        }

        @Override
        public void destroy() {
        }
    }

    private class RemoteControlSession
    extends ProcessProxy
    implements RemotingHub.SessionEventListener,
    ManagedProcess,
    TunnellerConnection.ExecHandler {
        long execId;
        String sessionId;
        AdvancedExecutor remoteExecutorService;
        FutureBox<Void> connected = new FutureBox();

        private RemoteControlSession() {
        }

        public AdvancedExecutor getExecutionService() {
            try {
                this.connected.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted");
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Execution failed", e.getCause());
            }
            return this.remoteExecutorService;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public void connected(DuplexStream stream) {
            this.remoteExecutorService = TunnellerJvmReplicator.this.hub.getExecutionService(this.sessionId);
            this.connected.setData(null);
            TunnellerJvmReplicator.this.logger.info().log("Conntected: " + stream);
        }

        public void interrupted(DuplexStream stream) {
            TunnellerJvmReplicator.this.logger.info().log("Interrupted: " + stream);
        }

        public void reconnected(DuplexStream stream) {
            TunnellerJvmReplicator.this.logger.info().log("Reconnected: " + stream);
        }

        public void suspend() {
            throw new UnsupportedOperationException();
        }

        public void resume() {
            throw new UnsupportedOperationException();
        }

        public void consoleFlush() {
        }

        public FutureEx<Integer> getExitCodeFuture() {
            return new FutureBox();
        }

        public void bindStdIn(InputStream is) {
            if (is != null) {
                TunnellerJvmReplicator.this.streamCopyService.link(is, this.getOutputStream());
            } else {
                try {
                    this.getOutputStream().close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void bindStdOut(OutputStream os) {
            if (os != null) {
                TunnellerJvmReplicator.this.streamCopyService.link(this.getInputStream(), os);
            } else {
                try {
                    this.getInputStream().close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void bindStdErr(OutputStream os) {
            if (os != null) {
                TunnellerJvmReplicator.this.streamCopyService.link(this.getErrorStream(), os);
            } else {
                try {
                    this.getErrorStream().close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void closed() {
            this.kill();
        }

        @Override
        public void destroy() {
            RemotingHub hub = TunnellerJvmReplicator.this.hub;
            if (hub != null) {
                hub.dropSession(this.sessionId);
            }
            this.kill();
        }

        protected void kill() {
            TunnellerConnection tc = TunnellerJvmReplicator.this.control;
            try {
                if (tc != null) {
                    tc.killProc(this.execId);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

