/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;

class StreamHelper {
    StreamHelper() {
    }

    public static byte[] readFile(File file) {
        try {
            int m;
            if (file.length() > 0x40000000L) {
                throw new ArrayIndexOutOfBoundsException("File is too big");
            }
            byte[] data = new byte[(int)file.length()];
            FileInputStream fis = new FileInputStream(file);
            for (int n = 0; n < data.length; n += m) {
                m = fis.read(data, n, data.length - n);
                if (m >= 0) continue;
                throw new RuntimeException("Cannot read file: " + file.getCanonicalPath());
            }
            fis.close();
            return data;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String digest(byte[] data, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] digest = md.digest(data);
            StringBuilder buf = new StringBuilder();
            for (byte b : digest) {
                buf.append(Integer.toHexString(0xF & b >> 4));
                buf.append(Integer.toHexString(0xF & b));
            }
            return buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream is) throws IOException {
        try {
            int n;
            StringBuilder buf = new StringBuilder();
            InputStreamReader reader = new InputStreamReader(is);
            char[] swap = new char[1024];
            while ((n = reader.read(swap)) >= 0) {
                buf.append(swap, 0, n);
            }
            String string = buf.toString();
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> toLines(InputStream is) throws IOException {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ArrayList<String> result = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            int n;
            byte[] buf = new byte[4096];
            while ((n = in.read(buf)) >= 0) {
                out.write(buf, 0, n);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }
}

