/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.util.Map;
import org.gridkit.vicluster.telecontrol.ssh.RemoteNodeProps;

class SshRemotingConfig {
    private String host;
    private String account;
    private String javaExec;
    private String jarCache;
    private String password;
    private String keyfile;
    private String authMethods;

    public void configure(Map<String, String> props) {
        if (props.containsKey(RemoteNodeProps.HOST)) {
            this.host = props.get(RemoteNodeProps.HOST);
        }
        if (props.containsKey(RemoteNodeProps.ACCOUNT)) {
            this.account = props.get(RemoteNodeProps.ACCOUNT);
        }
        if (props.containsKey(RemoteNodeProps.JAVA_EXEC)) {
            this.javaExec = props.get(RemoteNodeProps.JAVA_EXEC);
        }
        if (props.containsKey(RemoteNodeProps.JAR_CACHE_PATH)) {
            this.jarCache = props.get(RemoteNodeProps.JAR_CACHE_PATH);
        }
        if (props.containsKey(RemoteNodeProps.SSH_KEY_FILE)) {
            this.keyfile = props.get(RemoteNodeProps.SSH_KEY_FILE);
        }
        if (props.containsKey(RemoteNodeProps.PASSWORD)) {
            this.password = props.get(RemoteNodeProps.PASSWORD);
        }
        if (props.containsKey(RemoteNodeProps.SSH_AUTH_METHODS)) {
            this.authMethods = props.get(RemoteNodeProps.SSH_AUTH_METHODS);
        }
    }

    public void validate() {
        if (this.host == null) {
            throw new IllegalArgumentException("Host is not specified");
        }
        if (this.account == null) {
            throw new IllegalArgumentException("Account is not specified");
        }
        if (this.javaExec == null) {
            throw new IllegalArgumentException("Java command is not specified");
        }
        if (this.jarCache == null) {
            throw new IllegalArgumentException("Remote jar cache path is not specified");
        }
        if (this.password == null && this.keyfile == null) {
            throw new IllegalArgumentException("SSH credentials are missing");
        }
    }

    public String getFingerPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("host").append(":").append(this.host).append("|");
        sb.append("account").append(":").append(this.account).append("|");
        sb.append("javaExec").append(":").append(this.javaExec).append("|");
        sb.append("jarCachePath").append(":").append(this.jarCache);
        return sb.toString();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getJavaExec() {
        return this.javaExec;
    }

    public void setJavaExec(String javaExec) {
        this.javaExec = javaExec;
    }

    public String getJarCachePath() {
        return this.jarCache;
    }

    public void setJarCachePath(String jarCache) {
        this.jarCache = jarCache;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getKeyFile() {
        return this.keyfile;
    }

    public void setKeyFile(String keyfile) {
        this.keyfile = keyfile;
    }

    public String getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(String authMethods) {
        this.authMethods = authMethods;
    }
}

