/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.gridkit.internal.com.jcraft.jsch.ChannelExec;
import org.gridkit.internal.com.jcraft.jsch.JSchException;
import org.gridkit.internal.com.jcraft.jsch.Session;
import org.gridkit.vicluster.telecontrol.ExecCommand;

public class RemoteSshProcess
extends Process {
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private ChannelExec channel;

    public RemoteSshProcess(Session session, ExecCommand command) throws JSchException, IOException {
        this.channel = (ChannelExec)session.openChannel("exec");
        String cmd = command.getCommand();
        if (command.getWorkDir() != null) {
            cmd = "cd \"" + command.getWorkDir() + "\" && " + cmd;
        }
        this.channel.setCommand(cmd);
        this.stdin = this.channel.getOutputStream();
        this.stderr = this.channel.getErrStream();
        this.stdout = this.channel.getInputStream();
        for (Map.Entry entry : command.getEviroment().entrySet()) {
            this.channel.setEnv((String)entry.getKey(), (String)entry.getValue());
        }
        this.channel.connect();
    }

    @Override
    public int exitValue() {
        if (this.channel.isClosed()) {
            return this.channel.getExitStatus();
        }
        throw new IllegalStateException("Running");
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public int waitFor() throws InterruptedException {
        while (!this.channel.isClosed()) {
            Thread.sleep(100L);
        }
        return this.channel.getExitStatus();
    }

    @Override
    public void destroy() {
        if (!this.channel.isClosed()) {
            try {
                this.channel.sendSignal("KILL");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

