/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import org.gridkit.vicluster.telecontrol.StreamCopyService;
import org.gridkit.vicluster.telecontrol.StreamPipe;
import org.gridkit.vicluster.telecontrol.ssh.OutputStreamRemoteAdapter;

public class ProcessRemoteAdapter
extends Process
implements Serializable {
    private final transient Process process;
    private final RemoteProcess proxy;
    private OutputStream stdIn;
    private transient InputStream stdOut;
    private transient InputStream stdErr;

    public ProcessRemoteAdapter(Process process, StreamCopyService streamCopyService) {
        this.process = process;
        this.proxy = new ProcessProxy(streamCopyService);
        this.stdIn = new OutputStreamRemoteAdapter(process.getOutputStream());
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdIn;
    }

    @Override
    public synchronized InputStream getInputStream() {
        if (this.stdOut == null) {
            StreamPipe pipe = new StreamPipe(16384);
            this.proxy.setStdOutReceiver(new OutputStreamRemoteAdapter(pipe.getOutputStream()));
            this.stdOut = pipe.getInputStream();
        }
        return this.stdOut;
    }

    @Override
    public synchronized InputStream getErrorStream() {
        if (this.stdErr == null) {
            StreamPipe pipe = new StreamPipe(16384);
            this.proxy.setStdErrReceiver(new OutputStreamRemoteAdapter(pipe.getOutputStream()));
            this.stdErr = pipe.getInputStream();
        }
        return this.stdErr;
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.proxy.waitFor();
    }

    @Override
    public int exitValue() {
        return this.proxy.exitValue();
    }

    @Override
    public void destroy() {
        try {
            this.proxy.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class ProcessProxy
    implements RemoteProcess {
        private final StreamCopyService streamCopyService;

        public ProcessProxy(StreamCopyService streamCopyService) {
            this.streamCopyService = streamCopyService;
        }

        @Override
        public void setStdOutReceiver(OutputStream stream) {
            this.streamCopyService.link(ProcessRemoteAdapter.this.process.getInputStream(), stream);
        }

        @Override
        public void setStdErrReceiver(OutputStream stream) {
            this.streamCopyService.link(ProcessRemoteAdapter.this.process.getErrorStream(), stream);
        }

        @Override
        public int waitFor() throws InterruptedException {
            return ProcessRemoteAdapter.this.process.waitFor();
        }

        @Override
        public int exitValue() {
            return ProcessRemoteAdapter.this.process.exitValue();
        }

        @Override
        public void destroy() {
            ProcessRemoteAdapter.this.process.destroy();
        }
    }

    public static interface RemoteProcess
    extends Remote {
        public void setStdOutReceiver(OutputStream var1);

        public void setStdErrReceiver(OutputStream var1);

        public int waitFor() throws InterruptedException;

        public int exitValue();

        public void destroy() throws IOException;
    }
}

