/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.Arrays;

public class OutputStreamRemoteAdapter
extends OutputStream
implements Serializable {
    private final transient OutputStream sink;
    private final RemoteOutputInterface proxy;

    public OutputStreamRemoteAdapter(OutputStream sink) {
        this.sink = sink;
        this.proxy = new StreamProxy();
    }

    @Override
    public void write(int b) throws IOException {
        this.proxy.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.proxy.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.proxy.write(Arrays.copyOfRange(b, off, off + len));
    }

    @Override
    public void flush() throws IOException {
        this.proxy.flush();
    }

    @Override
    public void close() throws IOException {
        this.proxy.close();
    }

    private class StreamProxy
    implements RemoteOutputInterface {
        private StreamProxy() {
        }

        @Override
        public void write(int b) throws IOException {
            OutputStreamRemoteAdapter.this.sink.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            OutputStreamRemoteAdapter.this.sink.write(b);
        }

        @Override
        public void flush() throws IOException {
            OutputStreamRemoteAdapter.this.sink.flush();
        }

        @Override
        public void close() throws IOException {
            OutputStreamRemoteAdapter.this.sink.close();
        }
    }

    private static interface RemoteOutputInterface
    extends Remote {
        public void write(int var1) throws IOException;

        public void write(byte[] var1) throws IOException;

        public void flush() throws IOException;

        public void close() throws IOException;
    }
}

