/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.nanocloud.telecontrol.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.gridkit.nanocloud.RemoteNode;
import org.gridkit.vicluster.ViEngine;
import org.gridkit.vicluster.ViExecutor;
import org.gridkit.vicluster.WildProps;

public class HostConfigurationInitializer
implements ViEngine.Interceptor {
    public void process(String name, ViEngine.Phase phase, ViEngine.QuorumGame game) {
        if (phase == ViEngine.Phase.PRE_INIT) {
            game.rerunOnQuorum((ViEngine.Rerun)new Runner());
        }
    }

    public void processAdHoc(String name, ViExecutor node) {
        throw new IllegalStateException("Node is already initialized");
    }

    static class Runner
    implements ViEngine.Rerun {
        boolean first = true;

        Runner() {
        }

        public void rerun(ViEngine.QuorumGame game, Map<String, Object> changes) {
            if (this.first || changes.containsKey("remote:host") || changes.containsKey("remote:account") || changes.containsKey("remote:host-config")) {
                this.first = false;
                this.applyHostConfig(game);
                game.rerunOnUpdate((ViEngine.Rerun)this);
            }
        }

        private void set(ViEngine.QuorumGame game, String key, Object value) {
            Object old = game.getProp(key);
            if (old == null && value == null) {
                return;
            }
            if (value != null && value.equals(old)) {
                return;
            }
            game.setProp(key, value);
        }

        public void applyHostConfig(ViEngine.QuorumGame game) {
            String rhost = (String)game.get("remote:host");
            if (rhost == null) {
                return;
            }
            String host = ViEngine.Core.transform((String)rhost, (String)game.getNodeName());
            HashMap<String, Object> ec = new HashMap<String, Object>();
            ec.put("#spi:ssh:target-host", host);
            ec.put("#spi:ssh:target-account", game.get("remote:account"));
            String config = (String)game.get("remote:host-config");
            if (config != null) {
                try {
                    InputStream is = ViEngine.Core.openStream((String)config);
                    if (is != null) {
                        WildProps wp = new WildProps();
                        wp.load(is);
                        this.processHostConfig(host, (String)game.get("remote:account"), wp, ec);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (game.get(RemoteNode.PASSWORD) != null) {
                ec.put("#spi:ssh:password", game.get(RemoteNode.PASSWORD));
            }
            if (game.get("ssh:password") != null) {
                ec.put("#spi:ssh:password", game.get("ssh:password"));
            }
            if (ec.get("#spi:ssh:target-account") == null) {
                ec.put("#spi:ssh:target-account", System.getProperty("user.name"));
            }
            if (ec.get("#spi:ssh:password") == null && ec.get("#spi:ssh:private-key-file") == null) {
                ec.put("#spi:ssh:private-key-file", "~/.ssh/id_dsa|~/.ssh/id_rsa");
            }
            for (String key : ec.keySet()) {
                if (ec.get(key) == null) continue;
                this.set(game, key, ec.get(key));
            }
        }

        protected void processHostConfig(String host, String account, WildProps wp, Map<String, Object> ec) {
            if (account == null) {
                account = wp.get(host);
                ec.put("#spi:ssh:target-account", account);
            }
            if (account == null) {
                throw new RuntimeException("Cannot resolve remote account");
            }
            String key = account + "@" + host;
            ec.put("#spi:ssh:password", wp.get(key + "!" + "password"));
            ec.put("#spi:ssh:private-key-file", wp.get(key + "!" + "private-key"));
            if (wp.get(key + "!" + "address") != null) {
                ec.put("#spi:ssh:target-host", wp.get(key + "!" + "address"));
            }
            ec.put("#spi:remote-runtime:bootstrap-jvm-exec", wp.get(key + "!" + "java-exec"));
            ec.put("#spi:remote-runtime:jar-cache", wp.get(key + "!" + "jar-cache-path"));
            ec.put("#spi:ssh:jsch:PreferredAuthentications", wp.get(key + "!" + "jsch-auth"));
        }
    }
}

