/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.nanocloud;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.gridkit.nanocloud.Cloud;
import org.gridkit.nanocloud.CloudFactory;
import org.gridkit.vicluster.ViConfigurable;
import org.gridkit.vicluster.ViHelper;
import org.gridkit.vicluster.ViManager;
import org.gridkit.vicluster.ViProps;
import org.gridkit.vicluster.WildProps;
import org.gridkit.vicluster.telecontrol.ssh.RemoteNodeProps;

public class SimpleCloudFactory {
    public static Cloud createCloud() {
        return CloudFactory.createCloud();
    }

    public static Cloud createCloud(String configFile) {
        try {
            Cloud cloud = SimpleCloudFactory.createCloud();
            SimpleCloudFactory.applyConfig(cloud, SimpleCloudFactory.openStream(configFile));
            return cloud;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Cloud createCloud(Reader configReader) {
        Cloud cloud = SimpleCloudFactory.createCloud();
        SimpleCloudFactory.applyConfig(cloud, configReader);
        return cloud;
    }

    public static Cloud createSimpleSshCloud() {
        Cloud cloud = SimpleCloudFactory.createCloud();
        ViProps.at((ViConfigurable)cloud.node("**")).setRemoteType();
        cloud.node("**").setProp("jvm:exec-command", "java");
        cloud.node("**").setProp("#spi:remote-runtime:jar-cache", "/tmp/.telecontrol");
        cloud.node("**").setProp("remote:host-config", "?~/ssh-credentials.prop");
        RemoteNodeProps.at((ViConfigurable)cloud.node("**")).setRemoteHost("~%s!(.*)");
        return cloud;
    }

    public static void applyConfig(ViManager manager, String config) {
        try {
            SimpleCloudFactory.applyConfig((Cloud)manager, SimpleCloudFactory.openStream(config));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void applyConfig(Cloud manager, Reader reader) {
        WildProps wp = new WildProps();
        try {
            wp.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ViHelper.configure((Cloud)manager, (Iterable)wp.entryList());
    }

    public static void applyConfig(Cloud manager, InputStream is) {
        WildProps wp = new WildProps();
        try {
            wp.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ViHelper.configure((Cloud)manager, (Iterable)wp.entryList());
    }

    private static InputStream openStream(String path) throws IOException {
        InputStream is = null;
        if (path.startsWith("~/")) {
            String userHome = System.getProperty("user.home");
            File cpath = new File(new File(userHome), path.substring(2));
            is = new FileInputStream(cpath);
        } else if (path.startsWith("resource:")) {
            String rpath = path.substring("resource:".length());
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            is = cl.getResourceAsStream(rpath);
            if (is == null) {
                throw new FileNotFoundException("Resource not found '" + path + "'");
            }
        } else if (new File(path).exists()) {
            is = new FileInputStream(new File(path));
        } else {
            try {
                is = new URL(path).openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (is == null) {
                throw new FileNotFoundException("Cannot resolve path '" + path + "'");
            }
        }
        return is;
    }
}

