/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.util.shell;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.gridkit.lab.util.shell.ArchHelper;
import org.gridkit.lab.util.shell.GlobHelper;
import org.gridkit.lab.util.shell.Prompt;
import org.gridkit.lab.util.shell.Tailer;

public class Shell {
    private static final long ANCHOR = System.nanoTime();

    public static Prompt prompt() {
        return new SimpleShell();
    }

    private static long now() {
        return System.nanoTime() - ANCHOR;
    }

    public static class NonZeroExitCodeException
    extends IOException {
        private static final long serialVersionUID = 20121118L;

        NonZeroExitCodeException() {
        }

        NonZeroExitCodeException(String message, Throwable cause) {
            super(message, cause);
        }

        NonZeroExitCodeException(String message) {
            super(message);
        }

        NonZeroExitCodeException(Throwable cause) {
            super(cause);
        }
    }

    public static interface ChildProcess {
        public ChildProcess write(byte[] var1) throws IOException;

        public ChildProcess write(String var1) throws IOException;

        public ChildProcess writeln(String var1) throws IOException;

        public void done() throws IOException, InterruptedException;

        public void done(long var1, TimeUnit var3) throws IOException, InterruptedException, TimeoutException;
    }

    public static class SimpleShell
    implements Prompt,
    Serializable {
        private static final long serialVersionUID = 20121118L;
        private String baseDir = ".";
        private OutputStream stdOut = System.out;
        private long waitTimeoutNs = TimeUnit.MINUTES.toNanos(5L);
        private Map<String, String> env = new HashMap<String, String>();

        @Override
        public SimpleShell env(String var, String value) {
            this.env.put(var, value);
            return this;
        }

        @Override
        public Prompt out(OutputStream stdOut) {
            this.stdOut = stdOut == null ? System.out : stdOut;
            return this;
        }

        @Override
        public Prompt out(StringBuilder stdOut) {
            this.stdOut = stdOut == null ? System.out : new StringBufferOutputStream(stdOut);
            return this;
        }

        @Override
        public Prompt waitTimeout(long to, TimeUnit tu) {
            this.waitTimeoutNs = tu.toNanos(to);
            return this;
        }

        @Override
        public SimpleShell cd(String path) throws IOException {
            File nb = this.resolvePath(path).getCanonicalFile();
            if (!nb.exists() || !nb.isDirectory()) {
                throw new FileNotFoundException("No such directory: " + nb.getPath());
            }
            this.baseDir = nb.getPath();
            return this;
        }

        @Override
        public SimpleShell cd(String path, boolean mkdirs) throws IOException {
            File nb;
            if (mkdirs) {
                this.mkdirs(path);
            }
            if (!(nb = this.resolvePath(path).getCanonicalFile()).exists() || !nb.isDirectory()) {
                throw new FileNotFoundException("No such directory: " + nb.getPath());
            }
            this.baseDir = nb.getPath();
            return this;
        }

        @Override
        public SimpleShell mkdirs(String path) throws IOException {
            File target = this.resolvePath(path);
            if (target.isFile()) {
                throw new IOException("File already exists: " + target.getPath());
            }
            if (!target.isDirectory() && !target.mkdirs()) {
                throw new IOException("Filed to create path: " + target.getPath());
            }
            return this;
        }

        @Override
        public boolean exists(String path) throws IOException {
            return this.resolvePath(path).exists();
        }

        @Override
        public String pwd() {
            return new File(this.baseDir).getPath();
        }

        @Override
        public List<String> list() throws IOException {
            return this.list(".");
        }

        @Override
        public List<String> list(String path) throws IOException {
            File f = this.resolvePath(path);
            String[] fl = f.list();
            return fl == null ? Collections.emptyList() : Arrays.asList(fl);
        }

        @Override
        public List<String> find(String pattern) throws IOException {
            return this.filter(pattern, this.findFiles("."));
        }

        @Override
        public List<String> find(String path, String pattern) throws IOException {
            return this.filter(pattern, this.findFiles(path));
        }

        private List<String> filter(String pattern, Iterator<String> files) {
            Pattern p = GlobHelper.translate(pattern, "/");
            ArrayList<String> result = new ArrayList<String>();
            while (files.hasNext()) {
                String file = files.next();
                if (!GlobHelper.match(p, file, "/")) continue;
                result.add(file);
            }
            return result;
        }

        private Iterator<String> findFiles(String path) throws IOException {
            return new FileFinder(this.resolvePath(path));
        }

        @Override
        public Prompt rm(Collection<String> paths) throws IOException {
            for (String f : paths) {
                this.rm(f);
            }
            return this;
        }

        @Override
        public Prompt rm(Collection<String> paths, boolean rf) throws IOException {
            for (String f : paths) {
                this.rm(f, rf);
            }
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Prompt waitForMatch(String path, String pattern) throws TimeoutException, IOException {
            File file = this.resolvePath(path);
            Pattern re = Pattern.compile(pattern);
            long deadline = Shell.now() + this.waitTimeoutNs;
            while (true) {
                if (deadline < Shell.now()) {
                    throw new TimeoutException();
                }
                try {
                    Tailer tail = new Tailer(file);
                    try {
                        while (true) {
                            if (deadline < Shell.now()) {
                                throw new TimeoutException();
                            }
                            String line = tail.nextLine();
                            if (line == null) {
                                String rm = tail.getRemainder();
                                if (re.matcher(rm).find()) {
                                    SimpleShell simpleShell = this;
                                    return simpleShell;
                                }
                                try {
                                    Thread.sleep(300L);
                                }
                                catch (InterruptedException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            if (re.matcher(line).find()) break;
                        }
                        SimpleShell simpleShell = this;
                        return simpleShell;
                    }
                    finally {
                        tail.close();
                    }
                }
                catch (IOException e) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException ee) {
                        throw new RuntimeException(ee);
                    }
                }
            }
        }

        @Override
        public Prompt backup(String file) throws IOException {
            this.backup(file, false);
            return this;
        }

        @Override
        public Prompt backup(String file, boolean remove) throws IOException {
            File source = this.resolvePath(file);
            if (source.exists()) {
                String newName = file + new SimpleDateFormat(".yyyyMMdd.HHmmss").format(new Date());
                File dest = this.resolvePath(newName);
                if (remove) {
                    source.renameTo(dest);
                } else {
                    this.copy(source, dest);
                }
            }
            return this;
        }

        private void copy(File source, File dest) throws IOException {
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                try {
                    this.exec(new StringBuilder(), "xcopy", source.getAbsolutePath(), dest.getAbsolutePath(), "/E", "/I", "/Q");
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            try {
                this.exec("cp", "-r", source.getAbsolutePath(), dest.getAbsolutePath());
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        @Override
        public Prompt rm(String path) throws IOException {
            return this.rm(path, false);
        }

        @Override
        public Prompt rm(String path, boolean rf) throws IOException {
            File file = this.resolvePath(path);
            if (rf) {
                this.remove(file);
            } else {
                file.delete();
                if (file.exists()) {
                    throw new IOException("Cannot remove: " + file.getPath());
                }
            }
            return this;
        }

        private void remove(File file) throws IOException {
            if (file.isDirectory()) {
                File[] list = file.listFiles();
                if (list != null) {
                    for (File l : list) {
                        this.remove(l);
                    }
                }
                file.delete();
            } else if (file.exists()) {
                file.delete();
            }
            if (file.exists()) {
                throw new IOException("Cannot delete: " + file.getPath());
            }
        }

        @Override
        public Prompt wget(String url) throws IOException {
            URL u = new URL(url);
            String name = this.last(u.getPath());
            FileOutputStream out = new FileOutputStream(this.resolvePath(name));
            InputStream is = u.openStream();
            ArchHelper.copy(is, out);
            out.close();
            is.close();
            return this;
        }

        @Override
        public Prompt extract(String path) throws IOException {
            File file = this.resolvePath(path);
            if (!file.isFile()) {
                throw new FileNotFoundException(file.getPath());
            }
            if (file.getName().endsWith(".zip") || file.getName().endsWith(".jar")) {
                ArchHelper.uncompressZip(file, this.resolvePath("."));
            } else if (file.getName().endsWith(".tar.gz")) {
                String ungz = file.getName().substring(0, file.getName().length() - 3);
                File dest = new File(file.getParent(), ungz);
                ArchHelper.uncompressGz(file, dest);
                if (ungz.endsWith(".tar")) {
                    this.untar(dest);
                }
            } else if (file.getName().endsWith(".tar")) {
                this.untar(file);
            } else {
                throw new IOException("Unsupported archive type: " + path);
            }
            return this;
        }

        private void untar(File file) throws IOException {
            try {
                System.out.println("tar -xf " + file.getAbsolutePath());
                this.exec("tar", "-xf", file.getAbsolutePath());
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        private String last(String path) {
            int n = path.lastIndexOf(47);
            return n < 0 ? path : path.substring(n + 1);
        }

        @Override
        public Prompt writeTo(String path, String text) throws IOException {
            return this.writeTo(path, text.getBytes());
        }

        @Override
        public Prompt writeTo(String path, byte[] data) throws IOException {
            return this.writeTo(path, new ByteArrayInputStream(data));
        }

        @Override
        public Prompt writeTo(String path, InputStream data) throws IOException {
            return this.writeTo(path, data, false);
        }

        @Override
        public Prompt writeTo(String path, String text, boolean append) throws IOException {
            return this.writeTo(path, text.getBytes(), append);
        }

        @Override
        public Prompt writeTo(String path, byte[] data, boolean append) throws IOException {
            return this.writeTo(path, new ByteArrayInputStream(data), append);
        }

        @Override
        public Prompt writeTo(String path, InputStream data, boolean append) throws IOException {
            File file = this.resolvePath(path);
            FileOutputStream fos = new FileOutputStream(file, append);
            ArchHelper.copy(data, fos);
            fos.close();
            return this;
        }

        @Override
        public SimpleShell exec(String ... command) throws IOException, InterruptedException {
            return this.execAt(".", command);
        }

        @Override
        public SimpleShell execAt(String path, String ... command) throws IOException, InterruptedException {
            this.execAt(path, this.stdOut, command);
            return this;
        }

        @Override
        public Prompt exec(OutputStream stdOut, String ... command) throws IOException, InterruptedException {
            this.execAt(".", stdOut, command);
            return this;
        }

        @Override
        public Prompt exec(StringBuilder stdOut, String ... command) throws IOException, InterruptedException {
            this.exec(new StringBufferOutputStream(stdOut), command);
            return this;
        }

        @Override
        public Prompt execAt(String path, OutputStream stdOut, String ... command) throws IOException, InterruptedException {
            File dir = this.resolvePath(path);
            int ex = this.syncProcExec(dir, stdOut, command);
            if (ex != 0) {
                throw new NonZeroExitCodeException("Exit code: " + ex);
            }
            return this;
        }

        @Override
        public Prompt execAt(String path, StringBuilder stdOut, String ... command) throws IOException, InterruptedException {
            this.execAt(path, new StringBufferOutputStream(stdOut), command);
            return this;
        }

        @Override
        public ChildProcess execInteractive(String ... command) throws IOException, InterruptedException {
            return this.execInteractiveAt(".", this.stdOut, command);
        }

        @Override
        public ChildProcess execInteractive(OutputStream stdOut, String ... command) throws IOException, InterruptedException {
            return this.execInteractiveAt(".", stdOut, command);
        }

        @Override
        public ChildProcess execInteractive(StringBuilder stdOut, String ... command) throws IOException, InterruptedException {
            return this.execInteractiveAt(".", stdOut, command);
        }

        @Override
        public ChildProcess execInteractiveAt(String path, String ... command) throws IOException, InterruptedException {
            return this.execInteractiveAt(path, this.stdOut, command);
        }

        @Override
        public ChildProcess execInteractiveAt(String path, StringBuilder stdOut, String ... command) throws IOException, InterruptedException {
            return this.execInteractiveAt(path, new StringBufferOutputStream(stdOut), command);
        }

        @Override
        public ChildProcess execInteractiveAt(String path, OutputStream stdOut, String ... command) throws IOException, InterruptedException {
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(this.resolvePath(path));
            pb.environment().putAll(this.env);
            Process p = pb.start();
            ProcessMonitor mon = new ProcessMonitor(p, stdOut, System.err);
            mon.start();
            return mon;
        }

        private File resolvePath(String path) throws IOException {
            if (path.equals("{temp}")) {
                path = this.getTempDir().getPath();
            } else if (path.startsWith("{temp}/")) {
                path = new File(this.getTempDir(), path.substring("{temp}/".length())).getPath();
            } else if (path.equals("~")) {
                path = System.getProperty("user.home");
            } else if (path.startsWith("~/")) {
                String home = System.getProperty("user.home");
                path = new File(new File(home), path.substring(2)).getPath();
            }
            File p = new File(path);
            if (p.isAbsolute()) {
                return p;
            }
            File rpath = new File(new File(this.baseDir), path);
            return rpath;
        }

        private File getTempDir() throws IOException {
            File file = File.createTempFile("vigrid", ".tmp");
            return file.getParentFile();
        }

        int syncProcExec(String ... command) throws IOException, InterruptedException {
            return this.syncProcExec(new File(this.baseDir), System.out, command);
        }

        int syncProcExec(File path, OutputStream outSink, String ... command) throws IOException, InterruptedException {
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(path);
            pb.environment().putAll(this.env);
            Process p = pb.start();
            InputStream stdOut = p.getInputStream();
            InputStream stdErr = p.getErrorStream();
            p.getOutputStream().close();
            while (SimpleShell.isAlive(p)) {
                if (!(!SimpleShell.pump(stdOut, outSink) & !SimpleShell.pump(stdErr, System.err))) continue;
                Thread.sleep(100L);
            }
            SimpleShell.pump(stdOut, outSink);
            SimpleShell.pump(stdErr, System.err);
            outSink.flush();
            return p.exitValue();
        }

        private static boolean isAlive(Process p) {
            try {
                p.exitValue();
                return false;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        }

        private static boolean pump(InputStream is, OutputStream os) {
            try {
                byte[] buffer;
                int n;
                if (is.read(new byte[0]) < 0) {
                    return false;
                }
                int avail = is.available();
                if (avail > 0 && (n = is.read(buffer = new byte[avail])) > 0) {
                    os.write(buffer, 0, n);
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        public static void main(String[] args) throws IOException, InterruptedException {
            Shell.prompt().exec("echo", "ABC", "123");
            Shell.prompt().execAt("~", "dir");
            StringBuilder list = new StringBuilder();
            Shell.prompt().cd("~").exec(list, "dir").cd("C:\\").cd("WarZone").exec(list, "dir").out(list).exec("dir");
            System.err.println(list);
            ChildProcess x = Shell.prompt().execInteractiveAt(".", "cmd", "/C", "cat");
            x.writeln("This is cat");
            x.writeln("Another line");
            x.done();
            Shell.prompt().cd("~/test-dir", true).exec("pwd");
            Shell.prompt().cd("{temp}/test-dir", true).exec("pwd");
            Shell.prompt().cd("~").backup("test-dir");
        }

        private static class StringBufferOutputStream
        extends OutputStream {
            private final StringBuilder buf;

            private StringBufferOutputStream(StringBuilder buf) {
                this.buf = buf;
            }

            @Override
            public void write(int b) throws IOException {
                this.buf.append((char)b);
            }
        }

        private static class FileFinder
        implements Iterator<String> {
            private File root;
            private List<File> stack = new ArrayList<File>();
            private List<String> files = new ArrayList<String>();

            public FileFinder(File file) {
                this.root = file;
                this.stack.add(file);
            }

            @Override
            public boolean hasNext() {
                if (this.files.isEmpty()) {
                    while (!this.stack.isEmpty()) {
                        File top = this.stack.remove(this.stack.size() - 1);
                        File[] list = top.listFiles();
                        if (list == null) continue;
                        for (File f : list) {
                            this.files.add(this.getRelPath(this.root, f));
                            if (!f.isDirectory()) continue;
                            this.stack.add(f);
                        }
                    }
                }
                return !this.files.isEmpty();
            }

            private String getRelPath(File r, File f) {
                if (f.getParentFile().equals(r)) {
                    return f.getName();
                }
                return this.getRelPath(r, f.getParentFile()) + "/" + f.getName();
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.files.remove(0);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private static class ProcessMonitor
        extends Thread
        implements ChildProcess {
            private Process process;
            private InputStream stdOut;
            private InputStream stdErr;
            private OutputStream stdIn;
            private OutputStream outSink;
            private OutputStream errSink;

            public ProcessMonitor(Process process, OutputStream outSink, OutputStream errSink) {
                this.process = process;
                this.stdOut = process.getInputStream();
                this.stdErr = process.getErrorStream();
                this.stdIn = process.getOutputStream();
                this.outSink = outSink;
                this.errSink = errSink;
            }

            @Override
            public void run() {
                while (SimpleShell.isAlive(this.process)) {
                    if (!(!SimpleShell.pump(this.stdOut, this.outSink) & !SimpleShell.pump(this.stdErr, this.errSink))) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                SimpleShell.pump(this.stdOut, this.outSink);
                SimpleShell.pump(this.stdErr, this.errSink);
                try {
                    this.outSink.flush();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    this.errSink.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public ChildProcess write(byte[] raw) throws IOException {
                if (!SimpleShell.isAlive(this.process)) {
                    throw new IOException("Process has terminated");
                }
                this.stdIn.write(raw);
                this.stdIn.flush();
                return this;
            }

            @Override
            public ChildProcess write(String text) throws IOException {
                if (!SimpleShell.isAlive(this.process)) {
                    throw new IOException("Process has terminated");
                }
                this.stdIn.write(text.getBytes());
                this.stdIn.flush();
                return this;
            }

            @Override
            public ChildProcess writeln(String text) throws IOException {
                if (!SimpleShell.isAlive(this.process)) {
                    throw new IOException("Process has terminated");
                }
                this.stdIn.write((text + "\n").getBytes());
                this.stdIn.flush();
                return this;
            }

            @Override
            public void done() throws IOException, InterruptedException {
                this.stdIn.close();
                while (SimpleShell.isAlive(this.process)) {
                    if (!(!SimpleShell.pump(this.stdOut, this.outSink) & !SimpleShell.pump(this.stdErr, this.errSink))) continue;
                    Thread.sleep(100L);
                }
                SimpleShell.pump(this.stdOut, this.outSink);
                SimpleShell.pump(this.stdErr, this.errSink);
                int exitCode = this.process.exitValue();
                if (exitCode != 0) {
                    throw new NonZeroExitCodeException("Exit code " + exitCode);
                }
            }

            @Override
            public void done(long timeout, TimeUnit tu) throws IOException, InterruptedException, TimeoutException {
                long deadline = System.nanoTime() + tu.toNanos(timeout);
                this.stdIn.close();
                while (SimpleShell.isAlive(this.process)) {
                    if (!SimpleShell.pump(this.stdOut, this.outSink) & !SimpleShell.pump(this.stdErr, this.errSink) && deadline - System.nanoTime() > 0L) {
                        Thread.sleep(100L);
                    }
                    if (deadline - System.nanoTime() > 0L) continue;
                    this.process.destroy();
                    SimpleShell.pump(this.stdOut, this.outSink);
                    SimpleShell.pump(this.stdErr, this.errSink);
                    this.stdOut.close();
                    this.stdErr.close();
                    throw new TimeoutException();
                }
                SimpleShell.pump(this.stdOut, this.outSink);
                SimpleShell.pump(this.stdErr, this.errSink);
                int exitCode = this.process.exitValue();
                if (exitCode != 0) {
                    throw new NonZeroExitCodeException("Exit code " + exitCode);
                }
            }
        }
    }
}

