/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.internal.com.jcraft.jsch;

import org.gridkit.internal.com.jcraft.jsch.Buffer;
import org.gridkit.internal.com.jcraft.jsch.JSch;
import org.gridkit.internal.com.jcraft.jsch.JSchException;
import org.gridkit.internal.com.jcraft.jsch.KeyPair;
import org.gridkit.internal.com.jcraft.jsch.KeyPairGenRSA;
import org.gridkit.internal.com.jcraft.jsch.Util;

public class KeyPairRSA
extends KeyPair {
    private byte[] prv_array;
    private byte[] pub_array;
    private byte[] n_array;
    private byte[] p_array;
    private byte[] q_array;
    private byte[] ep_array;
    private byte[] eq_array;
    private byte[] c_array;
    private int key_size = 1024;
    private static final byte[] begin = Util.str2byte("-----BEGIN RSA PRIVATE KEY-----");
    private static final byte[] end = Util.str2byte("-----END RSA PRIVATE KEY-----");
    private static final byte[] sshrsa = Util.str2byte("ssh-rsa");

    public KeyPairRSA(JSch jsch) {
        super(jsch);
    }

    @Override
    void generate(int key_size) throws JSchException {
        this.key_size = key_size;
        try {
            Class<?> c = Class.forName(JSch.getConfig("keypairgen.rsa"));
            KeyPairGenRSA keypairgen = (KeyPairGenRSA)c.newInstance();
            keypairgen.init(key_size);
            this.pub_array = keypairgen.getE();
            this.prv_array = keypairgen.getD();
            this.n_array = keypairgen.getN();
            this.p_array = keypairgen.getP();
            this.q_array = keypairgen.getQ();
            this.ep_array = keypairgen.getEP();
            this.eq_array = keypairgen.getEQ();
            this.c_array = keypairgen.getC();
            Object var3_4 = null;
        }
        catch (Exception e) {
            if (e instanceof Throwable) {
                throw new JSchException(e.toString(), e);
            }
            throw new JSchException(e.toString());
        }
    }

    @Override
    byte[] getBegin() {
        return begin;
    }

    @Override
    byte[] getEnd() {
        return end;
    }

    @Override
    byte[] getPrivateKey() {
        int content = 1 + this.countLength(1) + 1 + 1 + this.countLength(this.n_array.length) + this.n_array.length + 1 + this.countLength(this.pub_array.length) + this.pub_array.length + 1 + this.countLength(this.prv_array.length) + this.prv_array.length + 1 + this.countLength(this.p_array.length) + this.p_array.length + 1 + this.countLength(this.q_array.length) + this.q_array.length + 1 + this.countLength(this.ep_array.length) + this.ep_array.length + 1 + this.countLength(this.eq_array.length) + this.eq_array.length + 1 + this.countLength(this.c_array.length) + this.c_array.length;
        int total = 1 + this.countLength(content) + content;
        byte[] plain = new byte[total];
        int index = 0;
        index = this.writeSEQUENCE(plain, index, content);
        index = this.writeINTEGER(plain, index, new byte[1]);
        index = this.writeINTEGER(plain, index, this.n_array);
        index = this.writeINTEGER(plain, index, this.pub_array);
        index = this.writeINTEGER(plain, index, this.prv_array);
        index = this.writeINTEGER(plain, index, this.p_array);
        index = this.writeINTEGER(plain, index, this.q_array);
        index = this.writeINTEGER(plain, index, this.ep_array);
        index = this.writeINTEGER(plain, index, this.eq_array);
        index = this.writeINTEGER(plain, index, this.c_array);
        return plain;
    }

    @Override
    boolean parse(byte[] plain) {
        try {
            int foo;
            int index = 0;
            int length = 0;
            if (this.vendor == 1) {
                if (plain[index] != 48) {
                    Buffer buf = new Buffer(plain);
                    this.pub_array = buf.getMPIntBits();
                    this.prv_array = buf.getMPIntBits();
                    this.n_array = buf.getMPIntBits();
                    byte[] u_array = buf.getMPIntBits();
                    this.p_array = buf.getMPIntBits();
                    this.q_array = buf.getMPIntBits();
                    return true;
                }
                return false;
            }
            int n = ++index;
            ++index;
            length = plain[n] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            if (plain[index] != 2) {
                return false;
            }
            int n2 = ++index;
            ++index;
            length = plain[n2] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            index += length;
            int n3 = ++index;
            ++index;
            length = plain[n3] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.n_array = new byte[length];
            System.arraycopy(plain, index, this.n_array, 0, length);
            index += length;
            int n4 = ++index;
            ++index;
            length = plain[n4] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.pub_array = new byte[length];
            System.arraycopy(plain, index, this.pub_array, 0, length);
            index += length;
            int n5 = ++index;
            ++index;
            length = plain[n5] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.prv_array = new byte[length];
            System.arraycopy(plain, index, this.prv_array, 0, length);
            index += length;
            int n6 = ++index;
            ++index;
            length = plain[n6] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.p_array = new byte[length];
            System.arraycopy(plain, index, this.p_array, 0, length);
            index += length;
            int n7 = ++index;
            ++index;
            length = plain[n7] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.q_array = new byte[length];
            System.arraycopy(plain, index, this.q_array, 0, length);
            index += length;
            int n8 = ++index;
            ++index;
            length = plain[n8] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.ep_array = new byte[length];
            System.arraycopy(plain, index, this.ep_array, 0, length);
            index += length;
            int n9 = ++index;
            ++index;
            length = plain[n9] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.eq_array = new byte[length];
            System.arraycopy(plain, index, this.eq_array, 0, length);
            index += length;
            int n10 = ++index;
            ++index;
            length = plain[n10] & 0xFF;
            if ((length & 0x80) != 0) {
                foo = length & 0x7F;
                length = 0;
                while (foo-- > 0) {
                    length = (length << 8) + (plain[index++] & 0xFF);
                }
            }
            this.c_array = new byte[length];
            System.arraycopy(plain, index, this.c_array, 0, length);
            index += length;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public byte[] getPublicKeyBlob() {
        byte[] foo = super.getPublicKeyBlob();
        if (foo != null) {
            return foo;
        }
        if (this.pub_array == null) {
            return null;
        }
        Buffer buf = new Buffer(sshrsa.length + 4 + this.pub_array.length + 4 + this.n_array.length + 4);
        buf.putString(sshrsa);
        buf.putString(this.pub_array);
        buf.putString(this.n_array);
        return buf.buffer;
    }

    @Override
    byte[] getKeyTypeName() {
        return sshrsa;
    }

    @Override
    public int getKeyType() {
        return 2;
    }

    @Override
    public int getKeySize() {
        return this.key_size;
    }

    @Override
    public void dispose() {
        super.dispose();
        Util.bzero(this.prv_array);
    }
}

