/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.nanocloud.test.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gridkit.nanocloud.VX;
import org.gridkit.vicluster.ViConf;
import org.gridkit.vicluster.ViConfigurable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenClasspathManager {
    private static Class<?> ANCHOR = MavenClasspathManager.class;
    private static Map<String, SourceInfo> CLASSPATH_JARS;
    private static File LOCAL_MAVEN_REPOPATH;

    public static File getLocalMavenRepoPath() {
        MavenClasspathManager.initClasspath();
        MavenClasspathManager.findLocalMavenRepo();
        return LOCAL_MAVEN_REPOPATH;
    }

    public static String getArtifactVersion(String groupId, String artifactId) {
        String cppath = "/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
        InputStream is = ANCHOR.getResourceAsStream(cppath);
        if (is != null) {
            try {
                Properties prop = new Properties();
                prop.load(is);
                is.close();
                return prop.getProperty("version");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        MavenClasspathManager.initClasspath();
        for (SourceInfo si : CLASSPATH_JARS.values()) {
            String path;
            String artBase;
            if (si.mavenProps != null && groupId.equals(si.mavenProps.get("groupId")) && artifactId.equals(si.mavenProps.get("artifactId"))) {
                return si.mavenProps.getProperty("version");
            }
            if (si.jarUrl == null || (artBase = MavenClasspathManager.getMavenArtifactBase(si.jarUrl)) == null || !artBase.endsWith(path = "/" + groupId.replace('.', '/') + "/" + artifactId)) continue;
            return MavenClasspathManager.getMavenVersionFromRepoPath(si.jarUrl);
        }
        throw new IllegalArgumentException("Cannot detect version for " + groupId + ":" + artifactId);
    }

    public static List<String> getAvailableVersions(String groupId, String artifactId) {
        File localRepo = MavenClasspathManager.getLocalMavenRepoPath();
        if (localRepo == null) {
            throw new IllegalArgumentException("Cannot detect local repo");
        }
        String[] gp = groupId.split("[.]");
        File path = localRepo;
        for (String p : gp) {
            path = new File(path, p);
        }
        path = new File(path, artifactId);
        ArrayList<String> version = new ArrayList<String>();
        for (File c : path.listFiles()) {
            if (!c.isDirectory() || MavenClasspathManager.findJar(c, artifactId) == null) continue;
            version.add(c.getName());
        }
        Collections.sort(version);
        return version;
    }

    public static void replaceArtifactVersion(ViConfigurable node, String groupId, String artifactId, String version) {
        MavenClasspathManager.removeArtifactVersion(node, groupId, artifactId);
        MavenClasspathManager.addArtifactVersion(node, groupId, artifactId, version);
    }

    public static void removeArtifactVersion(ViConfigurable node, String groupId, String artifactId) {
        String version = MavenClasspathManager.getArtifactVersion(groupId, artifactId);
        if (version == null) {
            throw new IllegalArgumentException("Artifact " + groupId + ":" + artifactId + " wasn't detected in classpath");
        }
        URL url = MavenClasspathManager.getArtifactClasspathUrl(groupId, artifactId);
        if (url == null) {
            throw new IllegalArgumentException("Artifact " + groupId + ":" + artifactId + " wasn't detected in classpath");
        }
        if ("jar".equals(url.getProtocol())) {
            url = MavenClasspathManager.baseUrlToJarUrl(url);
        }
        if (url == null) {
            MavenClasspathManager.dumpClasspathInfo();
            throw new IllegalArgumentException("Artifact " + groupId + ":" + artifactId + " wasn't detected in classpath");
        }
        try {
            File file;
            if ("file".equals(url.getProtocol())) {
                file = new File(url.toURI());
                if (!file.exists()) {
                    throw new IllegalArgumentException("Artifact " + groupId + ":" + artifactId + ":" + version + " is not available");
                }
            } else {
                throw new IllegalArgumentException("Bad URL " + url.toString());
            }
            ((ViConf.ClasspathConf)node.x(VX.CLASSPATH)).remove(file.getPath());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad URL " + url.toString());
        }
    }

    public static void removeArtifactVersion(ViConfigurable node, String groupId, String artifactId, String version) {
        URL url = MavenClasspathManager.findJar(groupId, artifactId, version);
        if (url == null) {
            throw new IllegalArgumentException("Cannot locate artifact: " + groupId + ":" + artifactId + ":" + version);
        }
        try {
            File file;
            if ("file".equals(url.getProtocol())) {
                file = new File(url.toURI());
                if (!file.exists()) {
                    throw new IllegalArgumentException("Artifact " + groupId + ":" + artifactId + ":" + version + " is not available");
                }
            } else {
                throw new IllegalArgumentException("Bad URL " + url.toString());
            }
            ((ViConf.ClasspathConf)node.x(VX.CLASSPATH)).remove(file.getPath());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad URL " + url.toString());
        }
    }

    public static void addArtifactVersion(ViConfigurable node, String groupId, String artifactId, String version) {
        URL url = MavenClasspathManager.findJar(groupId, artifactId, version);
        if (url == null) {
            throw new IllegalArgumentException("Artifact " + groupId + ":" + artifactId + ":" + version + " is not available");
        }
        try {
            File file;
            if ("file".equals(url.getProtocol())) {
                file = new File(url.toURI());
                if (!file.exists()) {
                    throw new IllegalArgumentException("Artifact " + groupId + ":" + artifactId + ":" + version + " is not available");
                }
            } else {
                throw new IllegalArgumentException("Bad URL " + url.toString());
            }
            ((ViConf.ClasspathConf)node.x(VX.CLASSPATH)).add(file.getPath());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad URL " + url.toString());
        }
    }

    private static String findJar(File c, String artifactId) {
        File[] files = c.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory() || !f.getName().startsWith(artifactId + "-") || !f.getName().endsWith(".jar") || f.getName().endsWith("-javadoc.jar") || f.getName().endsWith("-sources.jar")) continue;
                return f.getName();
            }
        }
        return null;
    }

    public static URL getArtifactClasspathUrl(String groupId, String artifactId) {
        String cppath = "/META-INF/maven/" + groupId + "/" + artifactId;
        URL url = ANCHOR.getResource(cppath);
        if (url != null) {
            try {
                String us = url.toExternalForm();
                us = us.substring(0, us.length() - cppath.length() + 1);
                return new URL(us);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to derive root path from resouce URL '" + url.toExternalForm() + "', resource '" + cppath + "'", e);
            }
        }
        MavenClasspathManager.initClasspath();
        for (SourceInfo si : CLASSPATH_JARS.values()) {
            if (!si.matchMavenProps(groupId, artifactId)) continue;
            try {
                return new URL(si.baseUrl);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        for (SourceInfo si : CLASSPATH_JARS.values()) {
            String path;
            String artBase;
            if (si.jarUrl == null || (artBase = MavenClasspathManager.getMavenArtifactBase(si.jarUrl)) == null || !artBase.endsWith(path = "/" + groupId.replace('.', '/') + "/" + artifactId)) continue;
            try {
                return new URL(si.baseUrl);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Cannot detect version for " + groupId + ":" + artifactId);
    }

    public static URL findJar(String groupId, String artifactId, String version) {
        File localRepo = MavenClasspathManager.getLocalMavenRepoPath();
        if (localRepo == null) {
            throw new IllegalArgumentException("Cannot detect local repo");
        }
        String[] gp = groupId.split("[.]");
        File path = localRepo;
        for (String p : gp) {
            path = new File(path, p);
        }
        path = new File(path, artifactId);
        String jarName = MavenClasspathManager.findJar(path = new File(path, version), artifactId);
        if (jarName != null) {
            File jar = new File(path, jarName);
            try {
                return jar.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    public static void dumpClasspathInfo() {
        MavenClasspathManager.initClasspath();
        for (SourceInfo si : CLASSPATH_JARS.values()) {
            if (si.mavenProps == null) {
                System.out.println("<unknown> " + si.baseUrl);
                continue;
            }
            String g = si.mavenProps.getProperty("groupId");
            String a = si.mavenProps.getProperty("artifactId");
            String v = si.mavenProps.getProperty("version");
            System.out.println(g + ":" + a + ":" + v + " " + si.baseUrl);
        }
    }

    private static URL baseUrlToJarUrl(URL url) {
        if ("jar".equals(url.getProtocol())) {
            String u = url.toExternalForm();
            int c = (u = u.substring("jar:".length())).lastIndexOf(33);
            if (c < 0) {
                throw new IllegalArgumentException(url.toExternalForm() + " doesn't ends with !/");
            }
            u = u.substring(0, c);
            try {
                return new URL(u);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Protocol is to jar: " + url.toExternalForm());
    }

    private static String getMavenArtifactBase(String path) {
        int c = path.lastIndexOf(47);
        if (c <= 0) {
            return null;
        }
        if ((c = (path = path.substring(0, c)).lastIndexOf(47)) <= 0) {
            return null;
        }
        path = path.substring(0, c);
        return path;
    }

    private static String getMavenVersionFromRepoPath(String path) {
        int c = path.lastIndexOf(47);
        if (c <= 0) {
            return null;
        }
        if ((c = (path = path.substring(0, c)).lastIndexOf(47)) <= 0) {
            return null;
        }
        path = path.substring(c + 1);
        return path;
    }

    private static synchronized void initClasspath() {
        SourceInfo info;
        if (CLASSPATH_JARS != null) {
            return;
        }
        CLASSPATH_JARS = new HashMap<String, SourceInfo>();
        for (URL url : MavenClasspathManager.getClasspathResources("META-INF/MANIFEST.MF")) {
            try {
                String upath = url.toString();
                upath = upath.substring(0, upath.length() - "META-INF/MANIFEST.MF".length());
                info = MavenClasspathManager.readInfo(upath);
                CLASSPATH_JARS.put(info.baseUrl, info);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (URL url : MavenClasspathManager.getClasspathResources("")) {
            try {
                info = MavenClasspathManager.readInfo(url.toString());
                CLASSPATH_JARS.put(info.baseUrl, info);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static List<URL> getClasspathResources(String path) {
        Enumeration<URL> en;
        try {
            en = ANCHOR.getClassLoader().getResources(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to scan classpath", e);
        }
        ArrayList<URL> list = new ArrayList<URL>();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        return list;
    }

    private static synchronized void findLocalMavenRepo() {
        MavenClasspathManager.initClasspath();
        if (LOCAL_MAVEN_REPOPATH != null) {
            return;
        }
        for (SourceInfo si : CLASSPATH_JARS.values()) {
            try {
                if (si.mavenProps == null || si.jarUrl == null) continue;
                String group = si.mavenProps.getProperty("groupId");
                String artifact = si.mavenProps.getProperty("artifactId");
                String version = si.mavenProps.getProperty("version");
                String path = "/" + group.replace('.', '/') + "/" + artifact + "/" + version + "/" + artifact + "-" + version + ".jar";
                if (!si.jarUrl.endsWith(path)) continue;
                String repo = si.jarUrl.substring(0, si.jarUrl.length() - path.length());
                URI ru = new URI(repo);
                LOCAL_MAVEN_REPOPATH = new File(ru);
                return;
            }
            catch (URISyntaxException uRISyntaxException) {
            }
        }
    }

    private static SourceInfo readInfo(String upath) throws IOException {
        SourceInfo info = new SourceInfo();
        try {
            URL url = new URL(upath + "META-INF/MANIFEST.MF");
            InputStream is = url.openStream();
            if (is != null) {
                Manifest mf = new Manifest();
                mf.read(is);
                is.close();
                info.manifest = mf;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (upath.startsWith("jar:")) {
            String jarPath = upath.substring("jar:".length());
            int c = jarPath.indexOf(33);
            info.jarUrl = jarPath = jarPath.substring(0, c);
        }
        info.baseUrl = upath;
        info.mavenProps = MavenClasspathManager.loadMavenProps(upath);
        return info;
    }

    private static Properties loadMavenProps(String upath) throws IOException {
        List<String> paths = MavenClasspathManager.listFiles(new ArrayList<String>(), new URL(upath + "META-INF/maven/"), "META-INF/maven/");
        Properties prop = null;
        for (String path : paths) {
            if (!path.endsWith("/pom.properties")) continue;
            if (prop != null) {
                return null;
            }
            URL url = new URL(upath + path);
            InputStream is = url.openStream();
            prop = new Properties();
            prop.load(is);
            is.close();
        }
        if (prop == null && upath.startsWith("file:") && !upath.endsWith("test-classes/")) {
            try {
                File f = new File(new URI(upath));
                File pom = new File(f.getParentFile().getParentFile(), "pom.xml");
                if (pom.isFile()) {
                    prop = MavenClasspathManager.loadPomProp(pom);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return prop;
    }

    private static Properties loadPomProp(File pom) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(pom);
        Element root = doc.getDocumentElement();
        String groupId = MavenClasspathManager.getText(root, "groupId");
        String artifactId = MavenClasspathManager.getText(root, "artifactId");
        String version = MavenClasspathManager.getText(root, "version");
        if (groupId == null || groupId.startsWith("$")) {
            groupId = MavenClasspathManager.getText(root, "parent/groupId");
        }
        if (version == null || version.startsWith("$")) {
            version = MavenClasspathManager.getText(root, "parent/version");
        }
        if (!(groupId == null || groupId.startsWith("$") || artifactId == null || artifactId.startsWith("$") || version == null || version.startsWith("$"))) {
            Properties props = new Properties();
            props.put("groupId", groupId);
            props.put("artifactId", artifactId);
            props.put("version", version);
            return props;
        }
        return null;
    }

    private static String getText(Element e, String path) {
        String[] tags;
        for (String tag : tags = path.split("[/]")) {
            Node n;
            block3: {
                NodeList nl = e.getChildNodes();
                for (int i = 0; i != nl.getLength(); ++i) {
                    n = nl.item(i);
                    if (!(n instanceof Element) || !tag.equals(((Element)n).getNodeName())) {
                        continue;
                    }
                    break block3;
                }
                return null;
            }
            e = (Element)n;
        }
        return e.getTextContent();
    }

    static List<String> findFiles(String path) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> en = cl.getResources(path);
        while (en.hasMoreElements()) {
            URL u = en.nextElement();
            MavenClasspathManager.listFiles(result, u, path);
        }
        return result;
    }

    static List<String> listFiles(List<String> results, URL packageURL, String path) throws IOException {
        if (packageURL.getProtocol().equals("jar")) {
            String jarFileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
            jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
            JarFile jf = new JarFile(jarFileName);
            Enumeration<JarEntry> jarEntries = jf.entries();
            while (jarEntries.hasMoreElements()) {
                String entryName = jarEntries.nextElement().getName();
                if (!entryName.startsWith(path)) continue;
                results.add(entryName);
            }
        } else {
            File dir = new File(packageURL.getFile());
            String cp = dir.getCanonicalPath();
            File root = dir;
            while (!cp.equals(new File(root, path).getCanonicalPath())) {
                root = root.getParentFile();
            }
            MavenClasspathManager.listFiles(results, root, dir);
        }
        return results;
    }

    static void listFiles(List<String> names, File root, File dir) {
        String rootPath = root.getAbsolutePath();
        if (dir.exists() && dir.isDirectory()) {
            String dname = dir.getAbsolutePath().substring(rootPath.length() + 1);
            dname = dname.replace('\\', '/');
            names.add(dname);
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    MavenClasspathManager.listFiles(names, root, file);
                    continue;
                }
                String name = file.getAbsolutePath().substring(rootPath.length() + 1);
                name = name.replace('\\', '/');
                names.add(name);
            }
        }
    }

    private static class SourceInfo {
        String baseUrl;
        String jarUrl;
        Manifest manifest;
        Properties mavenProps;

        private SourceInfo() {
        }

        public boolean matchMavenProps(String groupId, String artifactId) {
            if (this.mavenProps == null) {
                return false;
            }
            return groupId.equals(this.mavenProps.get("groupId")) && artifactId.equals(this.mavenProps.get("artifactId"));
        }
    }
}

