/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRefIterator;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesArray;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.ReleasableBytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.compress.CompressorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.common.recycler.Recycler;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.PageCacheRecycler;

public class TransportDecompressor
implements Closeable {
    private final Inflater inflater;
    private final PageCacheRecycler recycler;
    private final ArrayDeque<Recycler.V<byte[]>> pages;
    private int pageOffset = 16384;
    private boolean hasReadHeader = false;

    public TransportDecompressor(PageCacheRecycler recycler) {
        this.recycler = recycler;
        this.inflater = new Inflater(true);
        this.pages = new ArrayDeque(4);
    }

    public int decompress(BytesReference bytesReference) throws IOException {
        BytesRef ref;
        int bytesConsumed = 0;
        if (!this.hasReadHeader) {
            if (!CompressorFactory.COMPRESSOR.isCompressed(bytesReference)) {
                int maxToRead = Math.min(bytesReference.length(), 10);
                StringBuilder sb = new StringBuilder("stream marked as compressed, but no compressor found, first [").append(maxToRead).append("] content bytes out of [").append(bytesReference.length()).append("] readable bytes with message size [").append(bytesReference.length()).append("] ").append("] are [");
                for (int i = 0; i < maxToRead; ++i) {
                    sb.append(bytesReference.get(i)).append(",");
                }
                sb.append("]");
                throw new IllegalStateException(sb.toString());
            }
            this.hasReadHeader = true;
            int headerLength = CompressorFactory.COMPRESSOR.headerLength();
            bytesReference = bytesReference.slice(headerLength, bytesReference.length() - headerLength);
            bytesConsumed += headerLength;
        }
        BytesRefIterator refIterator = bytesReference.iterator();
        while ((ref = refIterator.next()) != null) {
            this.inflater.setInput(ref.bytes, ref.offset, ref.length);
            bytesConsumed += ref.length;
            boolean continueInflating = true;
            while (continueInflating) {
                Recycler.V<byte[]> page;
                boolean isNewPage;
                boolean bl = isNewPage = this.pageOffset == 16384;
                if (isNewPage) {
                    this.pageOffset = 0;
                    page = this.recycler.bytePage(false);
                } else {
                    page = this.pages.getLast();
                }
                byte[] output = page.v();
                try {
                    int bytesInflated = this.inflater.inflate(output, this.pageOffset, 16384 - this.pageOffset);
                    this.pageOffset += bytesInflated;
                    if (isNewPage) {
                        if (bytesInflated == 0) {
                            page.close();
                            this.pageOffset = 16384;
                        } else {
                            this.pages.add(page);
                        }
                    }
                }
                catch (DataFormatException e) {
                    throw new IOException("Exception while inflating bytes", e);
                }
                if (this.inflater.needsInput()) {
                    continueInflating = false;
                }
                if (this.inflater.finished()) {
                    bytesConsumed -= this.inflater.getRemaining();
                    continueInflating = false;
                }
                assert (!this.inflater.needsDictionary());
            }
        }
        return bytesConsumed;
    }

    public boolean canDecompress(int bytesAvailable) {
        return this.hasReadHeader || bytesAvailable >= CompressorFactory.COMPRESSOR.headerLength();
    }

    public boolean isEOS() {
        return this.inflater.finished();
    }

    public ReleasableBytesReference pollDecompressedPage() {
        if (this.pages.isEmpty()) {
            return null;
        }
        if (this.pages.size() == 1) {
            if (this.isEOS()) {
                Recycler.V<byte[]> page = this.pages.pollFirst();
                ReleasableBytesReference reference = new ReleasableBytesReference((BytesReference)new BytesArray(page.v(), 0, this.pageOffset), page);
                this.pageOffset = 0;
                return reference;
            }
            return null;
        }
        Recycler.V<byte[]> page = this.pages.pollFirst();
        return new ReleasableBytesReference((BytesReference)new BytesArray(page.v()), page);
    }

    @Override
    public void close() {
        this.inflater.end();
        for (Recycler.V<byte[]> page : this.pages) {
            page.close();
        }
    }
}

