/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.sort;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorable;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.SortField;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryRewriteContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.BucketedSort;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortFieldAndFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortOrder;

public class ScoreSortBuilder
extends SortBuilder<ScoreSortBuilder> {
    public static final String NAME = "_score";
    private static final SortFieldAndFormat SORT_SCORE = new SortFieldAndFormat(new SortField(null, SortField.Type.SCORE), DocValueFormat.RAW);
    private static final SortFieldAndFormat SORT_SCORE_REVERSE = new SortFieldAndFormat(new SortField(null, SortField.Type.SCORE, true), DocValueFormat.RAW);
    private static final ObjectParser<ScoreSortBuilder, Void> PARSER = new ObjectParser("_score", ScoreSortBuilder::new);

    public ScoreSortBuilder() {
        this.order(SortOrder.DESC);
    }

    public ScoreSortBuilder(StreamInput in) throws IOException {
        this.order(SortOrder.readFromStream(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.order.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(ORDER_FIELD.getPreferredName(), this.order);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static ScoreSortBuilder fromXContent(XContentParser parser, String fieldName) {
        return PARSER.apply(parser, null);
    }

    @Override
    public SortFieldAndFormat build(QueryShardContext context) {
        if (this.order == SortOrder.DESC) {
            return SORT_SCORE;
        }
        return SORT_SCORE_REVERSE;
    }

    @Override
    public BucketedSort buildBucketedSort(QueryShardContext context, int bucketSize, BucketedSort.ExtraData extra) throws IOException {
        return new BucketedSort.ForFloats(context.bigArrays(), this.order, DocValueFormat.RAW, bucketSize, extra){

            @Override
            public boolean needsScores() {
                return true;
            }

            @Override
            public BucketedSort.ForFloats.Leaf forLeaf(LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForFloats.Leaf(ctx){
                    private Scorable scorer;
                    private float score;

                    @Override
                    public void setScorer(Scorable scorer) {
                        this.scorer = scorer;
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        assert (doc == this.scorer.docID()) : "expected scorer to be on [" + doc + "] but was on [" + this.scorer.docID() + "]";
                        this.score = this.scorer.score();
                        return true;
                    }

                    @Override
                    protected float docValue() {
                        return this.score;
                    }
                };
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScoreSortBuilder other = (ScoreSortBuilder)object;
        return Objects.equals(this.order, other.order);
    }

    public int hashCode() {
        return Objects.hash(this.order);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public ScoreSortBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        return this;
    }

    static {
        PARSER.declareString((builder, order) -> builder.order(SortOrder.fromString(order)), ORDER_FIELD);
    }
}

