/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.profile.query;

import java.io.IOException;
import java.util.Collection;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorable;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.AbstractProfileBreakdown;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.Timer;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.query.ProfileWeight;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.query.QueryTimingType;

final class ProfileScorer
extends Scorer {
    private final Scorer scorer;
    private ProfileWeight profileWeight;
    private final Timer scoreTimer;
    private final Timer nextDocTimer;
    private final Timer advanceTimer;
    private final Timer matchTimer;
    private final Timer shallowAdvanceTimer;
    private final Timer computeMaxScoreTimer;
    private final Timer setMinCompetitiveScoreTimer;

    ProfileScorer(ProfileWeight w, Scorer scorer, AbstractProfileBreakdown<QueryTimingType> profile) throws IOException {
        super(w);
        this.scorer = scorer;
        this.profileWeight = w;
        this.scoreTimer = profile.getTimer(QueryTimingType.SCORE);
        this.nextDocTimer = profile.getTimer(QueryTimingType.NEXT_DOC);
        this.advanceTimer = profile.getTimer(QueryTimingType.ADVANCE);
        this.matchTimer = profile.getTimer(QueryTimingType.MATCH);
        this.shallowAdvanceTimer = profile.getTimer(QueryTimingType.SHALLOW_ADVANCE);
        this.computeMaxScoreTimer = profile.getTimer(QueryTimingType.COMPUTE_MAX_SCORE);
        this.setMinCompetitiveScoreTimer = profile.getTimer(QueryTimingType.SET_MIN_COMPETITIVE_SCORE);
    }

    @Override
    public int docID() {
        return this.scorer.docID();
    }

    @Override
    public float score() throws IOException {
        this.scoreTimer.start();
        try {
            float f = this.scorer.score();
            return f;
        }
        finally {
            this.scoreTimer.stop();
        }
    }

    @Override
    public Weight getWeight() {
        return this.profileWeight;
    }

    @Override
    public Collection<Scorable.ChildScorable> getChildren() throws IOException {
        return this.scorer.getChildren();
    }

    @Override
    public DocIdSetIterator iterator() {
        final DocIdSetIterator in = this.scorer.iterator();
        return new DocIdSetIterator(){

            @Override
            public int advance(int target) throws IOException {
                ProfileScorer.this.advanceTimer.start();
                try {
                    int n = in.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.advanceTimer.stop();
                }
            }

            @Override
            public int nextDoc() throws IOException {
                ProfileScorer.this.nextDocTimer.start();
                try {
                    int n = in.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.nextDocTimer.stop();
                }
            }

            @Override
            public int docID() {
                return in.docID();
            }

            @Override
            public long cost() {
                return in.cost();
            }
        };
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator in = this.scorer.twoPhaseIterator();
        if (in == null) {
            return null;
        }
        final DocIdSetIterator inApproximation = in.approximation();
        DocIdSetIterator approximation = new DocIdSetIterator(){

            @Override
            public int advance(int target) throws IOException {
                ProfileScorer.this.advanceTimer.start();
                try {
                    int n = inApproximation.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.advanceTimer.stop();
                }
            }

            @Override
            public int nextDoc() throws IOException {
                ProfileScorer.this.nextDocTimer.start();
                try {
                    int n = inApproximation.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.nextDocTimer.stop();
                }
            }

            @Override
            public int docID() {
                return inApproximation.docID();
            }

            @Override
            public long cost() {
                return inApproximation.cost();
            }
        };
        return new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                ProfileScorer.this.matchTimer.start();
                try {
                    boolean bl = in.matches();
                    return bl;
                }
                finally {
                    ProfileScorer.this.matchTimer.stop();
                }
            }

            @Override
            public float matchCost() {
                return in.matchCost();
            }
        };
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        this.shallowAdvanceTimer.start();
        try {
            int n = this.scorer.advanceShallow(target);
            return n;
        }
        finally {
            this.shallowAdvanceTimer.stop();
        }
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        this.computeMaxScoreTimer.start();
        try {
            float f = this.scorer.getMaxScore(upTo);
            return f;
        }
        finally {
            this.computeMaxScoreTimer.stop();
        }
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        this.setMinCompetitiveScoreTimer.start();
        try {
            this.scorer.setMinCompetitiveScore(minScore);
        }
        finally {
            this.setMinCompetitiveScoreTimer.stop();
        }
    }
}

