/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.profile;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.Timer;

public abstract class AbstractProfileBreakdown<T extends Enum<T>> {
    private final Timer[] timings;
    private final T[] timingTypes;

    public AbstractProfileBreakdown(Class<T> clazz) {
        this.timingTypes = (Enum[])clazz.getEnumConstants();
        this.timings = new Timer[this.timingTypes.length];
        for (int i = 0; i < this.timings.length; ++i) {
            this.timings[i] = new Timer();
        }
    }

    public Timer getTimer(T timing) {
        return this.timings[((Enum)timing).ordinal()];
    }

    public void setTimer(T timing, Timer timer) {
        this.timings[((Enum)timing).ordinal()] = timer;
    }

    public Map<String, Long> toBreakdownMap() {
        return this.buildBreakdownMap(this);
    }

    protected final Map<String, Long> buildBreakdownMap(AbstractProfileBreakdown<T> breakdown) {
        HashMap<Object, Long> map = new HashMap<Object, Long>(breakdown.timings.length * 2);
        for (T timingType : breakdown.timingTypes) {
            map.put(((Enum)timingType).toString(), breakdown.timings[((Enum)timingType).ordinal()].getApproximateTiming());
            map.put(((Enum)timingType).toString() + "_count", breakdown.timings[((Enum)timingType).ordinal()].getCount());
        }
        return Collections.unmodifiableMap(map);
    }

    protected Map<String, Object> toDebugMap() {
        return Collections.emptyMap();
    }

    public final long toNodeTime() {
        long total = 0L;
        for (T timingType : this.timingTypes) {
            total += this.timings[((Enum)timingType).ordinal()].getApproximateTiming();
        }
        return total;
    }
}

