/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DateFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceType;

public enum ValueType implements Writeable
{
    STRING(1, "string", "string", CoreValuesSourceType.BYTES, DocValueFormat.RAW),
    LONG(2, "byte|short|integer|long", "long", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    DOUBLE(3, "float|double", "double", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    NUMBER(4, "number", "number", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    DATE(5, "date", "date", CoreValuesSourceType.DATE, new DocValueFormat.DateTime(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER, ZoneOffset.UTC, DateFieldMapper.Resolution.MILLISECONDS)),
    IP(6, "ip", "ip", CoreValuesSourceType.IP, DocValueFormat.IP),
    NUMERIC(7, "numeric", "numeric", CoreValuesSourceType.NUMERIC, DocValueFormat.RAW),
    GEOPOINT(8, "geo_point", "geo_point", CoreValuesSourceType.GEOPOINT, DocValueFormat.GEOHASH),
    BOOLEAN(9, "boolean", "boolean", CoreValuesSourceType.BOOLEAN, DocValueFormat.BOOLEAN),
    RANGE(10, "range", "range", CoreValuesSourceType.RANGE, DocValueFormat.RAW);

    final String description;
    final ValuesSourceType valuesSourceType;
    final DocValueFormat defaultFormat;
    private final byte id;
    private String preferredName;
    public static final ParseField VALUE_TYPE;
    private static List<ValueType> numericValueTypes;
    private static List<ValueType> stringValueTypes;

    private ValueType(byte id, String description, String preferredName, ValuesSourceType valuesSourceType, DocValueFormat defaultFormat) {
        this.id = id;
        this.description = description;
        this.preferredName = preferredName;
        this.valuesSourceType = valuesSourceType;
        this.defaultFormat = defaultFormat;
    }

    public String getPreferredName() {
        return this.preferredName;
    }

    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    public boolean isA(ValueType valueType) {
        if (numericValueTypes.contains(this)) {
            return numericValueTypes.contains(valueType);
        }
        if (stringValueTypes.contains(this)) {
            return stringValueTypes.contains(valueType);
        }
        return this.equals(valueType);
    }

    public boolean isNotA(ValueType valueType) {
        return !this.isA(valueType);
    }

    public DocValueFormat defaultFormat() {
        return this.defaultFormat;
    }

    public static ValueType lenientParse(String type) {
        switch (type) {
            case "string": {
                return STRING;
            }
            case "double": 
            case "float": {
                return DOUBLE;
            }
            case "number": 
            case "numeric": 
            case "long": 
            case "integer": 
            case "short": 
            case "byte": {
                return LONG;
            }
            case "date": {
                return DATE;
            }
            case "ip": {
                return IP;
            }
            case "boolean": {
                return BOOLEAN;
            }
        }
        return null;
    }

    public String toString() {
        return this.description;
    }

    public static ValueType readFromStream(StreamInput in) throws IOException {
        byte id = in.readByte();
        for (ValueType valueType : ValueType.values()) {
            if (id != valueType.id) continue;
            return valueType;
        }
        throw new IOException("No ValueType found for id [" + id + "]");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id);
    }

    static {
        VALUE_TYPE = new ParseField("value_type", "valueType");
        numericValueTypes = Arrays.asList(DOUBLE, DATE, LONG, NUMBER, NUMERIC, BOOLEAN);
        stringValueTypes = Arrays.asList(STRING, IP);
    }
}

