/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParserUtils;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.ParsedMultiBucketAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.range.Range;

public class ParsedBinaryRange
extends ParsedMultiBucketAggregation<ParsedBucket>
implements Range {
    private static final ObjectParser<ParsedBinaryRange, Void> PARSER = new ObjectParser(ParsedBinaryRange.class.getSimpleName(), true, ParsedBinaryRange::new);

    @Override
    public String getType() {
        return "ip_range";
    }

    @Override
    public List<? extends Range.Bucket> getBuckets() {
        return this.buckets;
    }

    public static ParsedBinaryRange fromXContent(XContentParser parser, String name) throws IOException {
        ParsedBinaryRange aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedBinaryRange.declareMultiBucketAggregationFields(PARSER, parser -> ParsedBucket.fromXContent(parser, false), parser -> ParsedBucket.fromXContent(parser, true));
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements Range.Bucket {
        private String key;
        private String from;
        private String to;

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            return this.key;
        }

        @Override
        public Object getFrom() {
            return this.from;
        }

        @Override
        public String getFromAsString() {
            return this.from;
        }

        @Override
        public Object getTo() {
            return this.to;
        }

        @Override
        public String getToAsString() {
            return this.to;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.isKeyed()) {
                builder.startObject(this.key);
            } else {
                builder.startObject();
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            }
            if (this.from != null) {
                builder.field(Aggregation.CommonFields.FROM.getPreferredName(), this.from);
            }
            if (this.to != null) {
                builder.field(Aggregation.CommonFields.TO.getPreferredName(), this.to);
            }
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            this.getAggregations().toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            ParsedBucket bucket = new ParsedBucket();
            bucket.setKeyed(keyed);
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (keyed) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                bucket.key = currentFieldName;
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
            }
            ArrayList aggregations = new ArrayList();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (Aggregation.CommonFields.KEY.getPreferredName().equals(currentFieldName)) {
                        bucket.key = parser.text();
                        continue;
                    }
                    if (Aggregation.CommonFields.DOC_COUNT.getPreferredName().equals(currentFieldName)) {
                        bucket.setDocCount(parser.longValue());
                        continue;
                    }
                    if (Aggregation.CommonFields.FROM.getPreferredName().equals(currentFieldName)) {
                        bucket.from = parser.text();
                        continue;
                    }
                    if (!Aggregation.CommonFields.TO.getPreferredName().equals(currentFieldName)) continue;
                    bucket.to = parser.text();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                XContentParserUtils.parseTypedKeysObject(parser, "#", Aggregation.class, aggregations::add);
            }
            bucket.setAggregations(new Aggregations(aggregations));
            return bucket;
        }
    }
}

