/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.nested;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ObjectMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.CardinalityUpperBound;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.NonCollectingAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.nested.InternalReverseNested;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.nested.ReverseNestedAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;

public class ReverseNestedAggregatorFactory
extends AggregatorFactory {
    private final boolean unmapped;
    private final ObjectMapper parentObjectMapper;

    public ReverseNestedAggregatorFactory(String name, boolean unmapped, ObjectMapper parentObjectMapper, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, queryShardContext, parent, subFactories, metadata);
        this.unmapped = unmapped;
        this.parentObjectMapper = parentObjectMapper;
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (this.unmapped) {
            return new Unmapped(this.name, searchContext, parent, this.factories, metadata);
        }
        return new ReverseNestedAggregator(this.name, this.factories, this.parentObjectMapper, searchContext, parent, cardinality, metadata);
    }

    private static final class Unmapped
    extends NonCollectingAggregator {
        Unmapped(String name, SearchContext context, Aggregator parent, AggregatorFactories factories, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, factories, metadata);
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            return new InternalReverseNested(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
        }
    }
}

