/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.List;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.DoubleValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.HistogramValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.Histogram;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortOrder;

public class HistogramValuesSourceBuilder
extends CompositeValuesSourceBuilder<HistogramValuesSourceBuilder> {
    static final String TYPE = "histogram";
    static final ValuesSourceRegistry.RegistryKey<HistogramCompositeSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<HistogramCompositeSupplier>("histogram", HistogramCompositeSupplier.class);
    private static final ObjectParser<HistogramValuesSourceBuilder, Void> PARSER = new ObjectParser("histogram");
    private double interval = 0.0;

    static HistogramValuesSourceBuilder parse(String name, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new HistogramValuesSourceBuilder(name), null);
    }

    public static void register(ValuesSourceRegistry.Builder builder) {
        builder.register(REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC), (valuesSourceConfig, interval, name, hasScript, format, missingBucket, missingOrder, order) -> {
            ValuesSource.Numeric numeric = (ValuesSource.Numeric)valuesSourceConfig.getValuesSource();
            HistogramValuesSource vs = new HistogramValuesSource(numeric, interval);
            MappedFieldType fieldType = valuesSourceConfig.fieldType();
            return new CompositeValuesSourceConfig(name, fieldType, vs, valuesSourceConfig.format(), order, missingBucket, missingOrder, hasScript, (bigArrays, reader, size, addRequestCircuitBreakerBytes, compositeValuesSourceConfig) -> {
                ValuesSource.Numeric numericValuesSource = (ValuesSource.Numeric)compositeValuesSourceConfig.valuesSource();
                return new DoubleValuesSource(bigArrays, compositeValuesSourceConfig.fieldType(), numericValuesSource::doubleValues, compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
            });
        }, false);
    }

    public HistogramValuesSourceBuilder(String name) {
        super(name);
    }

    protected HistogramValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
        this.interval = in.readDouble();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.interval);
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.interval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.interval);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        HistogramValuesSourceBuilder other = (HistogramValuesSourceBuilder)obj;
        return Objects.equals(this.interval, other.interval);
    }

    @Override
    public String type() {
        return TYPE;
    }

    public double interval() {
        return this.interval;
    }

    public HistogramValuesSourceBuilder interval(double interval) {
        if (interval <= 0.0) {
            throw new IllegalArgumentException("[interval] must be greater than 0 for [histogram] source");
        }
        this.interval = interval;
        return this;
    }

    @Override
    protected ValuesSourceType getDefaultValuesSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    @Override
    protected CompositeValuesSourceConfig innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config) throws IOException {
        return queryShardContext.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config).apply(config, this.interval, this.name, this.script() != null, this.format(), this.missingBucket(), this.missingOrder(), this.order());
    }

    static {
        PARSER.declareDouble(HistogramValuesSourceBuilder::interval, Histogram.INTERVAL_FIELD);
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER);
    }

    @FunctionalInterface
    public static interface HistogramCompositeSupplier {
        public CompositeValuesSourceConfig apply(ValuesSourceConfig var1, double var2, String var4, boolean var5, String var6, boolean var7, MissingOrder var8, SortOrder var9);
    }
}

