/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations;

import java.util.function.IntFunction;

public abstract class CardinalityUpperBound {
    public static final CardinalityUpperBound NONE = new CardinalityUpperBound(){

        @Override
        public CardinalityUpperBound multiply(int bucketCount) {
            return NONE;
        }

        @Override
        public <R> R map(IntFunction<R> mapper) {
            return mapper.apply(0);
        }
    };
    public static final CardinalityUpperBound ONE = new KnownCardinalityUpperBound(1);
    public static final CardinalityUpperBound MANY = new CardinalityUpperBound(){

        @Override
        public CardinalityUpperBound multiply(int bucketCount) {
            if (bucketCount == 0) {
                return NONE;
            }
            return MANY;
        }

        @Override
        public <R> R map(IntFunction<R> mapper) {
            return mapper.apply(Integer.MAX_VALUE);
        }
    };

    private CardinalityUpperBound() {
    }

    public abstract CardinalityUpperBound multiply(int var1);

    public abstract <R> R map(IntFunction<R> var1);

    private static class KnownCardinalityUpperBound
    extends CardinalityUpperBound {
        private final int estimate;

        KnownCardinalityUpperBound(int estimate) {
            this.estimate = estimate;
        }

        @Override
        public CardinalityUpperBound multiply(int bucketCount) {
            if (bucketCount < 0) {
                throw new IllegalArgumentException("bucketCount must be positive but was [" + bucketCount + "]");
            }
            switch (bucketCount) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return this;
                }
            }
            long newEstimate = (long)this.estimate * (long)bucketCount;
            if (newEstimate >= Integer.MAX_VALUE) {
                return MANY;
            }
            return new KnownCardinalityUpperBound((int)newEstimate);
        }

        @Override
        public <R> R map(IntFunction<R> mapper) {
            return mapper.apply(this.estimate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KnownCardinalityUpperBound that = (KnownCardinalityUpperBound)o;
            return this.estimate == that.estimate;
        }

        public int hashCode() {
            return Integer.hashCode(this.estimate);
        }
    }
}

