/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.close.CloseIndexRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.close.CloseIndexResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActiveShardCount;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestChannel;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestToXContentListener;

public class RestCloseIndexAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestCloseIndexAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_close"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_close")));
    }

    @Override
    public String getName() {
        return "close_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        CloseIndexRequest closeIndexRequest = new CloseIndexRequest(Strings.splitStringByCommaToArray(request.param("index")));
        closeIndexRequest.masterNodeTimeout(request.paramAsTime("cluster_manager_timeout", closeIndexRequest.masterNodeTimeout()));
        RestCloseIndexAction.parseDeprecatedMasterTimeoutParameter(closeIndexRequest, request);
        closeIndexRequest.timeout(request.paramAsTime("timeout", closeIndexRequest.timeout()));
        closeIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, closeIndexRequest.indicesOptions()));
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            closeIndexRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
        }
        return channel -> client.admin().indices().close(closeIndexRequest, new RestToXContentListener<CloseIndexResponse>((RestChannel)channel));
    }
}

