/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.usage.NodesUsageRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.usage.NodesUsageResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BytesRestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestActions;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestBuilderListener;

public class RestNodesUsageAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_nodes/usage"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/usage"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/usage/{metric}"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/usage/{metric}")));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        Set<String> metrics = Strings.tokenizeByCommaToSet(request.param("metric", "_all"));
        NodesUsageRequest nodesUsageRequest = new NodesUsageRequest(nodesIds);
        nodesUsageRequest.timeout(request.param("timeout"));
        if (metrics.size() == 1 && metrics.contains("_all")) {
            nodesUsageRequest.all();
        } else {
            if (metrics.contains("_all")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains _all and individual metrics [%s]", request.path(), request.param("metric")));
            }
            nodesUsageRequest.clear();
            nodesUsageRequest.restActions(metrics.contains("rest_actions"));
            nodesUsageRequest.aggregations(metrics.contains("aggregations"));
        }
        return channel -> client.admin().cluster().nodesUsage(nodesUsageRequest, (ActionListener<NodesUsageResponse>)new RestBuilderListener<NodesUsageResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesUsageResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildNodesHeader(builder, this.channel.request(), response);
                builder.field("cluster_name", response.getClusterName().value());
                response.toXContent(builder, this.channel.request());
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    public String getName() {
        return "nodes_usage_action";
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

