/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.ingest;

import java.util.Map;
import java.util.function.BiConsumer;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.AbstractProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.ConfigurationUtils;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestDocument;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestService;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.Pipeline;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.Processor;
import org.graylog.shaded.opensearch2.org.opensearch.script.TemplateScript;

public class PipelineProcessor
extends AbstractProcessor {
    public static final String TYPE = "pipeline";
    private final TemplateScript.Factory pipelineTemplate;
    private final IngestService ingestService;

    PipelineProcessor(String tag, String description, TemplateScript.Factory pipelineTemplate, IngestService ingestService) {
        super(tag, description);
        this.pipelineTemplate = pipelineTemplate;
        this.ingestService = ingestService;
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        String pipelineName = ingestDocument.renderTemplate(this.pipelineTemplate);
        Pipeline pipeline = this.ingestService.getPipeline(pipelineName);
        if (pipeline != null) {
            ingestDocument.executePipeline(pipeline, handler);
        } else {
            handler.accept(null, new IllegalStateException("Pipeline processor configured for non-existent pipeline [" + pipelineName + "]"));
        }
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException("this method should not get executed");
    }

    Pipeline getPipeline(IngestDocument ingestDocument) {
        return this.ingestService.getPipeline(this.getPipelineToCallName(ingestDocument));
    }

    String getPipelineToCallName(IngestDocument ingestDocument) {
        return ingestDocument.renderTemplate(this.pipelineTemplate);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    TemplateScript.Factory getPipelineTemplate() {
        return this.pipelineTemplate;
    }

    public static final class Factory
    implements Processor.Factory {
        private final IngestService ingestService;

        public Factory(IngestService ingestService) {
            this.ingestService = ingestService;
        }

        @Override
        public PipelineProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            TemplateScript.Factory pipelineTemplate = ConfigurationUtils.readTemplateProperty(PipelineProcessor.TYPE, processorTag, config, "name", this.ingestService.getScriptService());
            return new PipelineProcessor(processorTag, description, pipelineTemplate, this.ingestService);
        }
    }
}

