/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.util.Locale;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;

public enum SimpleQueryStringFlag {
    ALL(-1),
    NONE(0),
    AND(1),
    NOT(2),
    OR(4),
    PREFIX(8),
    PHRASE(16),
    PRECEDENCE(32),
    ESCAPE(64),
    WHITESPACE(128),
    FUZZY(256),
    NEAR(512),
    SLOP(512);

    final int value;

    private SimpleQueryStringFlag(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    static int resolveFlags(String flags) {
        if (!Strings.hasLength(flags)) {
            return ALL.value();
        }
        int magic = NONE.value();
        for (String s : Strings.delimitedListToStringArray(flags, "|")) {
            if (s.isEmpty()) continue;
            try {
                SimpleQueryStringFlag flag = SimpleQueryStringFlag.valueOf(s.toUpperCase(Locale.ROOT));
                switch (flag) {
                    case NONE: {
                        return 0;
                    }
                    case ALL: {
                        return -1;
                    }
                }
                magic |= flag.value();
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unknown simple_query_string flag [" + s + "]");
            }
        }
        return magic;
    }
}

