/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.join.BitSetProducer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities.Similarity;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.SetOnce;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.client.Client;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.common.TriFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.Queries;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.Index;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSortConfig;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.IndexAnalyzers;
import org.graylog.shaded.opensearch2.org.opensearch.index.cache.bitset.BitsetFilterCache;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ContentPath;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DocumentMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ObjectMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TextFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.ParsedQuery;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryRewriteContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardException;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.Rewriteable;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.support.NestedScope;
import org.graylog.shaded.opensearch2.org.opensearch.index.similarity.SimilarityService;
import org.graylog.shaded.opensearch2.org.opensearch.script.Script;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScriptContext;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScriptFactory;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScriptService;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.AggregationUsageService;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RemoteClusterAware;

public class QueryShardContext
extends QueryRewriteContext {
    private final ScriptService scriptService;
    private final IndexSettings indexSettings;
    private final BigArrays bigArrays;
    private final MapperService mapperService;
    private final SimilarityService similarityService;
    private final BitsetFilterCache bitsetFilterCache;
    private final TriFunction<MappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataService;
    private final int shardId;
    private final IndexSearcher searcher;
    private boolean cacheable = true;
    private final SetOnce<Boolean> frozen = new SetOnce();
    private final Index fullyQualifiedIndex;
    private final Predicate<String> indexNameMatcher;
    private final BooleanSupplier allowExpensiveQueries;
    private final Map<String, Query> namedQueries = new HashMap<String, Query>();
    private boolean allowUnmappedFields;
    private boolean mapUnmappedFieldAsString;
    private NestedScope nestedScope;
    private final ValuesSourceRegistry valuesSourceRegistry;
    private SearchLookup lookup = null;

    public QueryShardContext(int shardId, IndexSettings indexSettings, BigArrays bigArrays, BitsetFilterCache bitsetFilterCache, TriFunction<MappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, SimilarityService similarityService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NamedWriteableRegistry namedWriteableRegistry, Client client, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias, Predicate<String> indexNameMatcher, BooleanSupplier allowExpensiveQueries, ValuesSourceRegistry valuesSourceRegistry) {
        this(shardId, indexSettings, bigArrays, bitsetFilterCache, indexFieldDataLookup, mapperService, similarityService, scriptService, xContentRegistry, namedWriteableRegistry, client, searcher, nowInMillis, clusterAlias, indexNameMatcher, allowExpensiveQueries, valuesSourceRegistry, false);
    }

    public QueryShardContext(int shardId, IndexSettings indexSettings, BigArrays bigArrays, BitsetFilterCache bitsetFilterCache, TriFunction<MappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, SimilarityService similarityService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NamedWriteableRegistry namedWriteableRegistry, Client client, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias, Predicate<String> indexNameMatcher, BooleanSupplier allowExpensiveQueries, ValuesSourceRegistry valuesSourceRegistry, boolean validate) {
        this(shardId, indexSettings, bigArrays, bitsetFilterCache, indexFieldDataLookup, mapperService, similarityService, scriptService, xContentRegistry, namedWriteableRegistry, client, searcher, nowInMillis, indexNameMatcher, new Index(RemoteClusterAware.buildRemoteIndexName(clusterAlias, indexSettings.getIndex().getName()), indexSettings.getIndex().getUUID()), allowExpensiveQueries, valuesSourceRegistry, validate);
    }

    public QueryShardContext(QueryShardContext source) {
        this(source.shardId, source.indexSettings, source.bigArrays, source.bitsetFilterCache, source.indexFieldDataService, source.mapperService, source.similarityService, source.scriptService, source.getXContentRegistry(), source.getWriteableRegistry(), source.client, source.searcher, source.nowInMillis, source.indexNameMatcher, source.fullyQualifiedIndex, source.allowExpensiveQueries, source.valuesSourceRegistry, source.validate());
    }

    private QueryShardContext(int shardId, IndexSettings indexSettings, BigArrays bigArrays, BitsetFilterCache bitsetFilterCache, TriFunction<MappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, SimilarityService similarityService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NamedWriteableRegistry namedWriteableRegistry, Client client, IndexSearcher searcher, LongSupplier nowInMillis, Predicate<String> indexNameMatcher, Index fullyQualifiedIndex, BooleanSupplier allowExpensiveQueries, ValuesSourceRegistry valuesSourceRegistry, boolean validate) {
        super(xContentRegistry, namedWriteableRegistry, client, nowInMillis, validate);
        this.shardId = shardId;
        this.similarityService = similarityService;
        this.mapperService = mapperService;
        this.bigArrays = bigArrays;
        this.bitsetFilterCache = bitsetFilterCache;
        this.indexFieldDataService = indexFieldDataLookup;
        this.allowUnmappedFields = indexSettings.isDefaultAllowUnmappedFields();
        this.nestedScope = new NestedScope();
        this.scriptService = scriptService;
        this.indexSettings = indexSettings;
        this.searcher = searcher;
        this.indexNameMatcher = indexNameMatcher;
        this.fullyQualifiedIndex = fullyQualifiedIndex;
        this.allowExpensiveQueries = allowExpensiveQueries;
        this.valuesSourceRegistry = valuesSourceRegistry;
    }

    private void reset() {
        this.allowUnmappedFields = this.indexSettings.isDefaultAllowUnmappedFields();
        this.lookup = null;
        this.namedQueries.clear();
        this.nestedScope = new NestedScope();
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.mapperService.getIndexAnalyzers();
    }

    public Similarity getSearchSimilarity() {
        return this.similarityService != null ? this.similarityService.similarity(this.mapperService) : null;
    }

    public List<String> defaultFields() {
        return this.indexSettings.getDefaultFields();
    }

    public boolean queryStringLenient() {
        return this.indexSettings.isQueryStringLenient();
    }

    public boolean queryStringAnalyzeWildcard() {
        return this.indexSettings.isQueryStringAnalyzeWildcard();
    }

    public boolean queryStringAllowLeadingWildcard() {
        return this.indexSettings.isQueryStringAllowLeadingWildcard();
    }

    public BitSetProducer bitsetFilter(Query filter) {
        return this.bitsetFilterCache.getBitSetProducer(filter);
    }

    public boolean allowExpensiveQueries() {
        return this.allowExpensiveQueries.getAsBoolean();
    }

    public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
        return (IFD)this.indexFieldDataService.apply(fieldType, this.fullyQualifiedIndex.getName(), () -> this.lookup().forkAndTrackFieldReferences(fieldType.name()));
    }

    public void addNamedQuery(String name, Query query) {
        if (query != null) {
            this.namedQueries.put(name, query);
        }
    }

    public Map<String, Query> copyNamedQueries() {
        return Collections.unmodifiableMap(new HashMap<String, Query>(this.namedQueries));
    }

    public Set<String> simpleMatchToIndexNames(String pattern) {
        return this.mapperService.simpleMatchToFullName(pattern);
    }

    public MappedFieldType getFieldType(String name) {
        return this.failIfFieldMappingNotFound(name, this.mapperService.fieldType(name));
    }

    public MappedFieldType fieldMapper(String name) {
        return this.failIfFieldMappingNotFound(name, this.mapperService.fieldType(name));
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.mapperService.getObjectMapper(name);
    }

    public boolean isMetadataField(String field) {
        return this.mapperService.isMetadataField(field);
    }

    public Set<String> sourcePath(String fullName) {
        return this.mapperService.sourcePath(fullName);
    }

    public DocumentMapper documentMapper(String type) {
        return this.mapperService.documentMapper();
    }

    public Analyzer getSearchAnalyzer(MappedFieldType fieldType) {
        if (fieldType.getTextSearchInfo().getSearchAnalyzer() != null) {
            return fieldType.getTextSearchInfo().getSearchAnalyzer();
        }
        return this.getMapperService().searchAnalyzer();
    }

    public Analyzer getSearchQuoteAnalyzer(MappedFieldType fieldType) {
        if (fieldType.getTextSearchInfo().getSearchQuoteAnalyzer() != null) {
            return fieldType.getTextSearchInfo().getSearchQuoteAnalyzer();
        }
        return this.getMapperService().searchQuoteAnalyzer();
    }

    public ValuesSourceRegistry getValuesSourceRegistry() {
        return this.valuesSourceRegistry;
    }

    public void setAllowUnmappedFields(boolean allowUnmappedFields) {
        this.allowUnmappedFields = allowUnmappedFields;
    }

    public void setMapUnmappedFieldAsString(boolean mapUnmappedFieldAsString) {
        this.mapUnmappedFieldAsString = mapUnmappedFieldAsString;
    }

    MappedFieldType failIfFieldMappingNotFound(String name, MappedFieldType fieldMapping) {
        if (fieldMapping != null || this.allowUnmappedFields) {
            return fieldMapping;
        }
        if (this.mapUnmappedFieldAsString) {
            TextFieldMapper.Builder builder = new TextFieldMapper.Builder(name, this.mapperService.getIndexAnalyzers());
            return builder.build(new Mapper.BuilderContext(this.indexSettings.getSettings(), new ContentPath(1))).fieldType();
        }
        throw new QueryShardException(this, "No field mapping can be found for the field with name [{}]", name);
    }

    public SearchLookup lookup() {
        if (this.lookup == null) {
            this.lookup = new SearchLookup(this.getMapperService(), (fieldType, searchLookup) -> this.indexFieldDataService.apply((MappedFieldType)fieldType, this.fullyQualifiedIndex.getName(), (Supplier<SearchLookup>)searchLookup));
        }
        return this.lookup;
    }

    public SearchLookup newFetchLookup() {
        return new SearchLookup(this.getMapperService(), (fieldType, searchLookup) -> this.indexFieldDataService.apply((MappedFieldType)fieldType, this.fullyQualifiedIndex.getName(), (Supplier<SearchLookup>)searchLookup));
    }

    public NestedScope nestedScope() {
        return this.nestedScope;
    }

    public Version indexVersionCreated() {
        return this.indexSettings.getIndexVersionCreated();
    }

    public boolean indexMatches(String pattern) {
        return this.indexNameMatcher.test(pattern);
    }

    public boolean indexSortedOnField(String field) {
        IndexSortConfig indexSortConfig = this.indexSettings.getIndexSortConfig();
        return indexSortConfig.hasPrimarySortOnField(field);
    }

    public ParsedQuery toQuery(QueryBuilder queryBuilder) {
        return this.toQuery(queryBuilder, q -> {
            Query query = q.toQuery(this);
            if (query == null) {
                query = Queries.newMatchNoDocsQuery("No query left after rewrite.");
            }
            return query;
        });
    }

    private ParsedQuery toQuery(QueryBuilder queryBuilder, CheckedFunction<QueryBuilder, Query, IOException> filterOrQuery) {
        this.reset();
        try {
            QueryBuilder rewriteQuery = Rewriteable.rewrite(queryBuilder, this, true);
            ParsedQuery parsedQuery = new ParsedQuery(filterOrQuery.apply(rewriteQuery), this.copyNamedQueries());
            return parsedQuery;
        }
        catch (ParsingException | QueryShardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryShardException(this, "failed to create query: {}", (Throwable)e, e.getMessage());
        }
        finally {
            this.reset();
        }
    }

    public Index index() {
        return this.indexSettings.getIndex();
    }

    public <FactoryType> FactoryType compile(Script script, ScriptContext<FactoryType> context) {
        FactoryType factory = this.scriptService.compile(script, context);
        if (factory instanceof ScriptFactory && !((ScriptFactory)factory).isResultDeterministic()) {
            this.failIfFrozen();
        }
        return factory;
    }

    public final void freezeContext() {
        this.frozen.set(Boolean.TRUE);
    }

    protected final void failIfFrozen() {
        this.cacheable = false;
        if (this.frozen.get() == Boolean.TRUE) {
            throw new IllegalArgumentException("features that prevent cachability are disabled on this context");
        }
        assert (this.frozen.get() == null) : this.frozen.get();
    }

    @Override
    public void registerAsyncAction(BiConsumer<Client, ActionListener<?>> asyncAction) {
        this.failIfFrozen();
        super.registerAsyncAction(asyncAction);
    }

    @Override
    public void executeAsyncActions(ActionListener listener) {
        this.failIfFrozen();
        super.executeAsyncActions(listener);
    }

    public final boolean isCacheable() {
        return this.cacheable;
    }

    public int getShardId() {
        return this.shardId;
    }

    @Override
    public final long nowInMillis() {
        this.failIfFrozen();
        return super.nowInMillis();
    }

    public Client getClient() {
        this.failIfFrozen();
        return this.client;
    }

    public QueryBuilder parseInnerQueryBuilder(XContentParser parser) throws IOException {
        return AbstractQueryBuilder.parseInnerQueryBuilder(parser);
    }

    @Override
    public final QueryShardContext convertToShardContext() {
        return this;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public MapperService getMapperService() {
        return this.mapperService;
    }

    public IndexReader getIndexReader() {
        return this.searcher == null ? null : this.searcher.getIndexReader();
    }

    public IndexSearcher searcher() {
        return this.searcher;
    }

    public Index getFullyQualifiedIndex() {
        return this.fullyQualifiedIndex;
    }

    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    public SimilarityService getSimilarityService() {
        return this.similarityService;
    }

    public BitsetFilterCache getBitsetFilterCache() {
        return this.bitsetFilterCache;
    }

    public AggregationUsageService getUsageService() {
        return this.valuesSourceRegistry.getUsageService();
    }
}

