/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.FieldType;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.AnalysisMode;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.IndexAnalyzers;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.NamedAnalyzer;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TypeParsers;
import org.graylog.shaded.opensearch2.org.opensearch.index.similarity.SimilarityProvider;

public final class TextParams {
    private TextParams() {
    }

    public static ParametrizedFieldMapper.Parameter<Boolean> norms(boolean defaultValue, Function<FieldMapper, Boolean> initializer) {
        return ParametrizedFieldMapper.Parameter.boolParam("norms", true, initializer, defaultValue).setMergeValidator((o, n) -> o == n || o != false && n == false);
    }

    public static ParametrizedFieldMapper.Parameter<SimilarityProvider> similarity(Function<FieldMapper, SimilarityProvider> init) {
        return new ParametrizedFieldMapper.Parameter<SimilarityProvider>("similarity", false, () -> null, (n, c, o) -> TypeParsers.resolveSimilarity(c, n, o), init).setSerializer((b, f, v) -> b.field(f, v == null ? null : v.name()), v -> v == null ? null : v.name()).acceptsNull();
    }

    public static ParametrizedFieldMapper.Parameter<String> indexOptions(Function<FieldMapper, String> initializer) {
        return ParametrizedFieldMapper.Parameter.restrictedStringParam("index_options", false, initializer, "positions", "docs", "freqs", "offsets");
    }

    public static FieldType buildFieldType(Supplier<Boolean> indexed, Supplier<Boolean> stored, Supplier<String> indexOptions, Supplier<Boolean> norms, Supplier<String> termVectors) {
        FieldType ft = new FieldType();
        ft.setStored(stored.get());
        ft.setTokenized(true);
        ft.setIndexOptions(TextParams.toIndexOptions(indexed.get(), indexOptions.get()));
        ft.setOmitNorms(norms.get() == false);
        TextParams.setTermVectorParams(termVectors.get(), ft);
        return ft;
    }

    public static IndexOptions toIndexOptions(boolean indexed, String indexOptions) {
        if (!indexed) {
            return IndexOptions.NONE;
        }
        switch (indexOptions) {
            case "docs": {
                return IndexOptions.DOCS;
            }
            case "freqs": {
                return IndexOptions.DOCS_AND_FREQS;
            }
            case "positions": {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case "offsets": {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        throw new IllegalArgumentException("Unknown [index_options] value: [" + indexOptions + "]");
    }

    public static ParametrizedFieldMapper.Parameter<String> termVectors(Function<FieldMapper, String> initializer) {
        return ParametrizedFieldMapper.Parameter.restrictedStringParam("term_vector", false, initializer, "no", "yes", "with_positions", "with_offsets", "with_positions_offsets", "with_positions_payloads", "with_positions_offsets_payloads");
    }

    public static void setTermVectorParams(String configuration, FieldType fieldType) {
        switch (configuration) {
            case "no": {
                fieldType.setStoreTermVectors(false);
                return;
            }
            case "yes": {
                fieldType.setStoreTermVectors(true);
                return;
            }
            case "with_positions": {
                fieldType.setStoreTermVectors(true);
                fieldType.setStoreTermVectorPositions(true);
                return;
            }
            case "with_offsets": {
                fieldType.setStoreTermVectors(true);
                fieldType.setStoreTermVectorOffsets(true);
                return;
            }
            case "with_positions_offsets": {
                fieldType.setStoreTermVectors(true);
                fieldType.setStoreTermVectorPositions(true);
                fieldType.setStoreTermVectorOffsets(true);
                return;
            }
            case "with_positions_payloads": {
                fieldType.setStoreTermVectors(true);
                fieldType.setStoreTermVectorPositions(true);
                fieldType.setStoreTermVectorPayloads(true);
                return;
            }
            case "with_positions_offsets_payloads": {
                fieldType.setStoreTermVectors(true);
                fieldType.setStoreTermVectorPositions(true);
                fieldType.setStoreTermVectorOffsets(true);
                fieldType.setStoreTermVectorPayloads(true);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown [term_vector] setting: [" + configuration + "]");
    }

    public static final class Analyzers {
        public final ParametrizedFieldMapper.Parameter<NamedAnalyzer> indexAnalyzer = ParametrizedFieldMapper.Parameter.analyzerParam("analyzer", false, m -> m.fieldType().indexAnalyzer(), indexAnalyzers::getDefaultIndexAnalyzer).setSerializerCheck((id, ic, a) -> id || ic || !Objects.equals(a, this.getSearchAnalyzer()) || !Objects.equals(a, this.getSearchQuoteAnalyzer())).setValidator(a -> a.checkAllowedInMode(AnalysisMode.INDEX_TIME));
        public final ParametrizedFieldMapper.Parameter<NamedAnalyzer> searchAnalyzer = ParametrizedFieldMapper.Parameter.analyzerParam("search_analyzer", true, m -> m.fieldType().getTextSearchInfo().getSearchAnalyzer(), () -> {
            NamedAnalyzer defaultAnalyzer = indexAnalyzers.get("default_search");
            if (defaultAnalyzer != null) {
                return defaultAnalyzer;
            }
            return this.indexAnalyzer.get();
        }).setSerializerCheck((id, ic, a) -> id || ic || !Objects.equals(a, this.getSearchQuoteAnalyzer())).setValidator(a -> a.checkAllowedInMode(AnalysisMode.SEARCH_TIME));
        public final ParametrizedFieldMapper.Parameter<NamedAnalyzer> searchQuoteAnalyzer = ParametrizedFieldMapper.Parameter.analyzerParam("search_quote_analyzer", true, m -> m.fieldType().getTextSearchInfo().getSearchQuoteAnalyzer(), () -> {
            NamedAnalyzer defaultAnalyzer = indexAnalyzers.get("default_search_quoted");
            if (defaultAnalyzer != null) {
                return defaultAnalyzer;
            }
            return this.searchAnalyzer.get();
        }).setValidator(a -> a.checkAllowedInMode(AnalysisMode.SEARCH_TIME));
        public final IndexAnalyzers indexAnalyzers;

        public Analyzers(IndexAnalyzers indexAnalyzers) {
            this.indexAnalyzers = indexAnalyzers;
        }

        public NamedAnalyzer getIndexAnalyzer() {
            return this.indexAnalyzer.getValue();
        }

        public NamedAnalyzer getSearchAnalyzer() {
            return this.searchAnalyzer.getValue();
        }

        public NamedAnalyzer getSearchQuoteAnalyzer() {
            return this.searchQuoteAnalyzer.getValue();
        }
    }
}

