/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.AnalyzerWrapper;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.CachingTokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.shingle.FixedShingleFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.Field;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.FieldType;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexableFieldType;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Term;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.spans.FieldMaskingSpanQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.spans.SpanQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.spans.SpanTermQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.AutomatonQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MultiTermQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.PrefixQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TermQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Automata;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Automaton;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Operations;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Iterators;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.AnalyzerScope;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.IndexAnalyzers;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.NamedAnalyzer;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParseContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.SourceValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.StringFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TextFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TextParams;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.similarity.SimilarityProvider;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;

public class SearchAsYouTypeFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "search_as_you_type";
    private static final int MAX_SHINGLE_SIZE_LOWER_BOUND = 2;
    private static final int MAX_SHINGLE_SIZE_UPPER_BOUND = 4;
    private static final String PREFIX_FIELD_SUFFIX = "._index_prefix";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexAnalyzers()));
    private final boolean index;
    private final boolean store;
    private final String indexOptions;
    private final String termVectors;
    private final int maxShingleSize;
    private final PrefixFieldMapper prefixField;
    private final ShingleFieldMapper[] shingleFields;
    private final Builder builder;

    private static SearchAsYouTypeFieldMapper toType(FieldMapper in) {
        return (SearchAsYouTypeFieldMapper)in;
    }

    private static SearchAsYouTypeFieldType ft(FieldMapper in) {
        return SearchAsYouTypeFieldMapper.toType(in).fieldType();
    }

    private static int countPosition(TokenStream stream) throws IOException {
        assert (stream instanceof CachingTokenFilter);
        PositionIncrementAttribute posIncAtt = stream.getAttribute(PositionIncrementAttribute.class);
        stream.reset();
        int positionCount = 0;
        while (stream.incrementToken()) {
            if (posIncAtt.getPositionIncrement() == 0) continue;
            positionCount += posIncAtt.getPositionIncrement();
        }
        return positionCount;
    }

    public SearchAsYouTypeFieldMapper(String simpleName, SearchAsYouTypeFieldType mappedFieldType, FieldMapper.CopyTo copyTo, PrefixFieldMapper prefixField, ShingleFieldMapper[] shingleFields, Builder builder) {
        super(simpleName, mappedFieldType, FieldMapper.MultiFields.empty(), copyTo);
        this.prefixField = prefixField;
        this.shingleFields = shingleFields;
        this.maxShingleSize = builder.maxShingleSize.getValue();
        this.index = builder.index.getValue();
        this.store = builder.store.getValue();
        this.indexOptions = builder.indexOptions.getValue();
        this.termVectors = builder.termVectors.getValue();
        this.builder = builder;
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        String value;
        String string = value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null) {
            return;
        }
        context.doc().add(new Field(this.fieldType().name(), value, (IndexableFieldType)this.fieldType().fieldType));
        for (ShingleFieldMapper subFieldMapper : this.shingleFields) {
            context.doc().add(new Field(subFieldMapper.fieldType().name(), value, (IndexableFieldType)subFieldMapper.getLuceneFieldType()));
        }
        context.doc().add(new Field(this.prefixField.fieldType().name(), value, (IndexableFieldType)this.prefixField.getLuceneFieldType()));
        if (this.fieldType().fieldType.omitNorms()) {
            this.createFieldNamesField(context);
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.builder.analyzers.indexAnalyzers).init(this);
    }

    public static String getShingleFieldName(String parentField, int shingleSize) {
        return parentField + "._" + shingleSize + "gram";
    }

    @Override
    public SearchAsYouTypeFieldType fieldType() {
        return (SearchAsYouTypeFieldType)super.fieldType();
    }

    public int maxShingleSize() {
        return this.maxShingleSize;
    }

    public PrefixFieldMapper prefixField() {
        return this.prefixField;
    }

    public ShingleFieldMapper[] shingleFields() {
        return this.shingleFields;
    }

    @Override
    public Iterator<Mapper> iterator() {
        ArrayList<FieldMapper> subIterators = new ArrayList<FieldMapper>();
        subIterators.add(this.prefixField);
        subIterators.addAll(Arrays.asList(this.shingleFields));
        Iterator<Mapper> concat = Iterators.concat(super.iterator(), subIterators.iterator());
        return concat;
    }

    static class SearchAsYouTypeFieldType
    extends StringFieldType {
        final FieldType fieldType;
        PrefixFieldType prefixField;
        ShingleFieldType[] shingleFields = new ShingleFieldType[0];

        SearchAsYouTypeFieldType(String name, FieldType fieldType, SimilarityProvider similarity, NamedAnalyzer searchAnalyzer, NamedAnalyzer searchQuoteAnalyzer, Map<String, String> meta) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, fieldType.stored(), false, new TextSearchInfo(fieldType, similarity, searchAnalyzer, searchQuoteAnalyzer), meta);
            this.fieldType = fieldType;
        }

        public void setPrefixField(PrefixFieldType prefixField) {
            this.prefixField = prefixField;
        }

        public void setShingleFields(ShingleFieldType[] shingleFields) {
            this.shingleFields = shingleFields;
        }

        @Override
        public String typeName() {
            return SearchAsYouTypeFieldMapper.CONTENT_TYPE;
        }

        private ShingleFieldType shingleFieldForPositions(int positions) {
            int indexFromShingleSize = Math.max(positions - 2, 0);
            return this.shingleFields[Math.min(indexFromShingleSize, this.shingleFields.length - 1)];
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.toString(this.name(), context, format);
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            if (this.prefixField == null || !this.prefixField.termLengthWithinBounds(value.length())) {
                return super.prefixQuery(value, method, caseInsensitive, context);
            }
            Query query = this.prefixField.prefixQuery(value, method, caseInsensitive, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE) {
                return new ConstantScoreQuery(query);
            }
            return query;
        }

        @Override
        public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            int numPos = SearchAsYouTypeFieldMapper.countPosition(stream);
            if (this.shingleFields.length == 0 || slop > 0 || TextFieldMapper.TextFieldType.hasGaps(stream) || numPos <= 1) {
                return TextFieldMapper.createPhraseQuery(stream, this.name(), slop, enablePositionIncrements);
            }
            ShingleFieldType shingleField = this.shingleFieldForPositions(numPos);
            stream = new FixedShingleFilter(stream, shingleField.shingleSize);
            return shingleField.phraseQuery(stream, 0, true);
        }

        @Override
        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            int numPos = SearchAsYouTypeFieldMapper.countPosition(stream);
            if (this.shingleFields.length == 0 || slop > 0 || TextFieldMapper.TextFieldType.hasGaps(stream) || numPos <= 1) {
                return TextFieldMapper.createPhraseQuery(stream, this.name(), slop, enablePositionIncrements);
            }
            ShingleFieldType shingleField = this.shingleFieldForPositions(numPos);
            stream = new FixedShingleFilter(stream, shingleField.shingleSize);
            return shingleField.multiPhraseQuery(stream, 0, true);
        }

        @Override
        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) throws IOException {
            int numPos = SearchAsYouTypeFieldMapper.countPosition(stream);
            if (this.shingleFields.length == 0 || slop > 0 || TextFieldMapper.TextFieldType.hasGaps(stream) || numPos <= 1) {
                return TextFieldMapper.createPhrasePrefixQuery(stream, this.name(), slop, maxExpansions, null, null);
            }
            ShingleFieldType shingleField = this.shingleFieldForPositions(numPos);
            stream = new FixedShingleFilter(stream, shingleField.shingleSize);
            return shingleField.phrasePrefixQuery(stream, 0, maxExpansions);
        }

        @Override
        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
            if (this.prefixField != null && this.prefixField.termLengthWithinBounds(value.length())) {
                return new FieldMaskingSpanQuery(new SpanTermQuery(new Term(this.prefixField.name(), this.indexedValueForSearch(value))), this.name());
            }
            SpanMultiTermQueryWrapper<PrefixQuery> spanMulti = new SpanMultiTermQueryWrapper<PrefixQuery>(new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            spanMulti.setRewriteMethod(method);
            return spanMulti;
        }
    }

    static final class PrefixFieldMapper
    extends FieldMapper {
        PrefixFieldMapper(FieldType fieldType, PrefixFieldType mappedFieldType) {
            super(mappedFieldType.name(), fieldType, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        @Override
        public PrefixFieldType fieldType() {
            return (PrefixFieldType)super.fieldType();
        }

        FieldType getLuceneFieldType() {
            return this.fieldType;
        }

        @Override
        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        }

        @Override
        protected String contentType() {
            return "prefix";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    static final class ShingleFieldMapper
    extends FieldMapper {
        ShingleFieldMapper(FieldType fieldType, ShingleFieldType mappedFieldtype) {
            super(mappedFieldtype.name(), fieldType, mappedFieldtype, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        FieldType getLuceneFieldType() {
            return this.fieldType;
        }

        @Override
        public ShingleFieldType fieldType() {
            return (ShingleFieldType)super.fieldType();
        }

        @Override
        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        }

        @Override
        protected String contentType() {
            return "shingle";
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> index = ParametrizedFieldMapper.Parameter.indexParam(m -> SearchAsYouTypeFieldMapper.toType((FieldMapper)m).index, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> store = ParametrizedFieldMapper.Parameter.storeParam(m -> SearchAsYouTypeFieldMapper.toType((FieldMapper)m).store, false);
        private final ParametrizedFieldMapper.Parameter<Boolean> docValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> false, false).setValidator(v -> {
            if (v.booleanValue()) {
                throw new MapperParsingException("Cannot set [doc_values] on field of type [search_as_you_type]");
            }
        }).alwaysSerialize();
        private final ParametrizedFieldMapper.Parameter<Integer> maxShingleSize = ParametrizedFieldMapper.Parameter.intParam("max_shingle_size", false, m -> SearchAsYouTypeFieldMapper.toType((FieldMapper)m).maxShingleSize, 3).setValidator(v -> {
            if (v < 2 || v > 4) {
                throw new MapperParsingException("[max_shingle_size] must be at least [2] and at most [4], got [" + v + "]");
            }
        }).alwaysSerialize();
        final TextParams.Analyzers analyzers;
        final ParametrizedFieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> SearchAsYouTypeFieldMapper.ft(m).getTextSearchInfo().getSimilarity());
        final ParametrizedFieldMapper.Parameter<String> indexOptions = TextParams.indexOptions(m -> SearchAsYouTypeFieldMapper.toType((FieldMapper)m).indexOptions);
        final ParametrizedFieldMapper.Parameter<Boolean> norms = TextParams.norms(true, m -> SearchAsYouTypeFieldMapper.ft(m).getTextSearchInfo().hasNorms());
        final ParametrizedFieldMapper.Parameter<String> termVectors = TextParams.termVectors(m -> SearchAsYouTypeFieldMapper.toType((FieldMapper)m).termVectors);
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name, IndexAnalyzers indexAnalyzers) {
            super(name);
            this.analyzers = new TextParams.Analyzers(indexAnalyzers);
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.index, this.store, this.docValues, this.maxShingleSize, this.analyzers.indexAnalyzer, this.analyzers.searchAnalyzer, this.analyzers.searchQuoteAnalyzer, this.similarity, this.indexOptions, this.norms, this.termVectors, this.meta);
        }

        @Override
        public SearchAsYouTypeFieldMapper build(Mapper.BuilderContext context) {
            FieldType fieldType = new FieldType();
            fieldType.setIndexOptions(TextParams.toIndexOptions(this.index.getValue(), this.indexOptions.getValue()));
            fieldType.setOmitNorms(this.norms.getValue() == false);
            fieldType.setStored(this.store.getValue());
            TextParams.setTermVectorParams(this.termVectors.getValue(), fieldType);
            NamedAnalyzer indexAnalyzer = this.analyzers.getIndexAnalyzer();
            NamedAnalyzer searchAnalyzer = this.analyzers.getSearchAnalyzer();
            SearchAsYouTypeFieldType ft = new SearchAsYouTypeFieldType(this.buildFullName(context), fieldType, this.similarity.getValue(), this.analyzers.getSearchAnalyzer(), this.analyzers.getSearchQuoteAnalyzer(), this.meta.getValue());
            ft.setIndexAnalyzer(this.analyzers.getIndexAnalyzer());
            FieldType prefixft = new FieldType(fieldType);
            prefixft.setStoreTermVectors(false);
            prefixft.setOmitNorms(true);
            prefixft.setStored(false);
            String fullName = this.buildFullName(context);
            SearchAsYouTypeAnalyzer prefixIndexWrapper = SearchAsYouTypeAnalyzer.withShingleAndPrefix(indexAnalyzer.analyzer(), this.maxShingleSize.getValue());
            NamedAnalyzer prefixSearchWrapper = new NamedAnalyzer(searchAnalyzer.name(), searchAnalyzer.scope(), SearchAsYouTypeAnalyzer.withShingle(searchAnalyzer.analyzer(), this.maxShingleSize.getValue()));
            TextSearchInfo prefixSearchInfo = new TextSearchInfo(prefixft, this.similarity.getValue(), prefixSearchWrapper, searchAnalyzer);
            PrefixFieldType prefixFieldType = new PrefixFieldType(fullName, prefixSearchInfo, 1, 20);
            prefixFieldType.setIndexAnalyzer(new NamedAnalyzer(indexAnalyzer.name(), AnalyzerScope.INDEX, prefixIndexWrapper));
            PrefixFieldMapper prefixFieldMapper = new PrefixFieldMapper(prefixft, prefixFieldType);
            ShingleFieldMapper[] shingleFieldMappers = new ShingleFieldMapper[this.maxShingleSize.getValue() - 1];
            ShingleFieldType[] shingleFieldTypes = new ShingleFieldType[this.maxShingleSize.getValue() - 1];
            for (int i = 0; i < shingleFieldMappers.length; ++i) {
                int shingleSize = i + 2;
                FieldType shingleft = new FieldType(fieldType);
                shingleft.setStored(false);
                String fieldName = SearchAsYouTypeFieldMapper.getShingleFieldName(this.buildFullName(context), shingleSize);
                SearchAsYouTypeAnalyzer shingleIndexWrapper = SearchAsYouTypeAnalyzer.withShingle(indexAnalyzer.analyzer(), shingleSize);
                NamedAnalyzer shingleSearchWrapper = new NamedAnalyzer(searchAnalyzer.name(), searchAnalyzer.scope(), SearchAsYouTypeAnalyzer.withShingle(searchAnalyzer.analyzer(), shingleSize));
                NamedAnalyzer shingleSearchQuoteWrapper = new NamedAnalyzer(searchAnalyzer.name(), searchAnalyzer.scope(), SearchAsYouTypeAnalyzer.withShingle(searchAnalyzer.analyzer(), shingleSize));
                TextSearchInfo textSearchInfo = new TextSearchInfo(shingleft, this.similarity.getValue(), shingleSearchWrapper, shingleSearchQuoteWrapper);
                ShingleFieldType shingleFieldType = new ShingleFieldType(fieldName, shingleSize, textSearchInfo);
                shingleFieldType.setIndexAnalyzer(new NamedAnalyzer(indexAnalyzer.name(), AnalyzerScope.INDEX, shingleIndexWrapper));
                shingleFieldType.setPrefixFieldType(prefixFieldType);
                shingleFieldTypes[i] = shingleFieldType;
                shingleFieldMappers[i] = new ShingleFieldMapper(shingleft, shingleFieldType);
            }
            ft.setPrefixField(prefixFieldType);
            ft.setShingleFields(shingleFieldTypes);
            return new SearchAsYouTypeFieldMapper(this.name, ft, this.copyTo.build(), prefixFieldMapper, shingleFieldMappers, this);
        }
    }

    static class ShingleFieldType
    extends StringFieldType {
        final int shingleSize;
        PrefixFieldType prefixFieldType;

        ShingleFieldType(String name, int shingleSize, TextSearchInfo textSearchInfo) {
            super(name, true, false, false, textSearchInfo, Collections.emptyMap());
            this.shingleSize = shingleSize;
        }

        void setPrefixFieldType(PrefixFieldType prefixFieldType) {
            this.prefixFieldType = prefixFieldType;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.toString(this.name(), context, format);
        }

        @Override
        public String typeName() {
            return SearchAsYouTypeFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            if (this.prefixFieldType == null || !this.prefixFieldType.termLengthWithinBounds(value.length())) {
                return super.prefixQuery(value, method, caseInsensitive, context);
            }
            Query query = this.prefixFieldType.prefixQuery(value, method, caseInsensitive, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE) {
                return new ConstantScoreQuery(query);
            }
            return query;
        }

        @Override
        public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            return TextFieldMapper.createPhraseQuery(stream, this.name(), slop, enablePositionIncrements);
        }

        @Override
        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            return TextFieldMapper.createPhraseQuery(stream, this.name(), slop, enablePositionIncrements);
        }

        @Override
        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) throws IOException {
            String prefixFieldName = slop > 0 ? null : this.prefixFieldType.name();
            return TextFieldMapper.createPhrasePrefixQuery(stream, this.name(), slop, maxExpansions, prefixFieldName, this.prefixFieldType::termLengthWithinBounds);
        }

        @Override
        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
            if (this.prefixFieldType != null && this.prefixFieldType.termLengthWithinBounds(value.length())) {
                return new FieldMaskingSpanQuery(new SpanTermQuery(new Term(this.prefixFieldType.name(), this.indexedValueForSearch(value))), this.name());
            }
            SpanMultiTermQueryWrapper<PrefixQuery> spanMulti = new SpanMultiTermQueryWrapper<PrefixQuery>(new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            spanMulti.setRewriteMethod(method);
            return spanMulti;
        }
    }

    static final class PrefixFieldType
    extends StringFieldType {
        final int minChars;
        final int maxChars;
        final String parentField;

        PrefixFieldType(String parentField, TextSearchInfo textSearchInfo, int minChars, int maxChars) {
            super(parentField + SearchAsYouTypeFieldMapper.PREFIX_FIELD_SUFFIX, true, false, false, textSearchInfo, Collections.emptyMap());
            this.minChars = minChars;
            this.maxChars = maxChars;
            this.parentField = parentField;
        }

        boolean termLengthWithinBounds(int length) {
            return length >= this.minChars - 1 && length <= this.maxChars;
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            if (value.length() >= this.minChars) {
                if (caseInsensitive) {
                    return super.termQueryCaseInsensitive(value, context);
                }
                return super.termQuery(value, context);
            }
            ArrayList<Automaton> automata = new ArrayList<Automaton>();
            automata.add(Automata.makeString(value));
            for (int i = value.length(); i < this.minChars; ++i) {
                automata.add(Automata.makeAnyChar());
            }
            Automaton automaton = Operations.concatenate(automata);
            AutomatonQuery query = new AutomatonQuery(new Term(this.name(), value + "*"), automaton);
            query.setRewriteMethod(method);
            return new BooleanQuery.Builder().add(query, BooleanClause.Occur.SHOULD).add(new TermQuery(new Term(this.parentField, value)), BooleanClause.Occur.SHOULD).build();
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.toString(this.name(), context, format);
        }

        @Override
        public String typeName() {
            return "prefix";
        }

        public String toString() {
            return super.toString() + ",prefixChars=" + this.minChars + ":" + this.maxChars;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException();
        }
    }

    static class SearchAsYouTypeAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer delegate;
        private final int shingleSize;
        private final boolean indexPrefixes;

        private SearchAsYouTypeAnalyzer(Analyzer delegate, int shingleSize, boolean indexPrefixes) {
            super(delegate.getReuseStrategy());
            this.delegate = Objects.requireNonNull(delegate);
            this.shingleSize = shingleSize;
            this.indexPrefixes = indexPrefixes;
        }

        static SearchAsYouTypeAnalyzer withShingle(Analyzer delegate, int shingleSize) {
            return new SearchAsYouTypeAnalyzer(delegate, shingleSize, false);
        }

        static SearchAsYouTypeAnalyzer withShingleAndPrefix(Analyzer delegate, int shingleSize) {
            return new SearchAsYouTypeAnalyzer(delegate, shingleSize, true);
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        @Override
        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            TokenStream tokenStream = components.getTokenStream();
            if (this.indexPrefixes) {
                tokenStream = new TrailingShingleTokenFilter(tokenStream, this.shingleSize - 1);
            }
            tokenStream = new FixedShingleFilter(tokenStream, this.shingleSize, " ", "");
            if (this.indexPrefixes) {
                tokenStream = new EdgeNGramTokenFilter(tokenStream, 1, 20, true);
            }
            return new Analyzer.TokenStreamComponents(components.getSource(), tokenStream);
        }

        public int shingleSize() {
            return this.shingleSize;
        }

        public boolean indexPrefixes() {
            return this.indexPrefixes;
        }

        public String toString() {
            return "<" + this.getClass().getCanonicalName() + " shingleSize=[" + this.shingleSize + "] indexPrefixes=[" + this.indexPrefixes + "]>";
        }

        private static class TrailingShingleTokenFilter
        extends TokenFilter {
            private final int extraPositionIncrements;
            private final PositionIncrementAttribute positionIncrementAttribute;

            TrailingShingleTokenFilter(TokenStream input, int extraPositionIncrements) {
                super(input);
                this.extraPositionIncrements = extraPositionIncrements;
                this.positionIncrementAttribute = this.addAttribute(PositionIncrementAttribute.class);
            }

            @Override
            public boolean incrementToken() throws IOException {
                return this.input.incrementToken();
            }

            @Override
            public void end() throws IOException {
                super.end();
                this.positionIncrementAttribute.setPositionIncrement(this.extraPositionIncrements);
            }
        }
    }

    public static class Defaults {
        public static final int MIN_GRAM = 1;
        public static final int MAX_GRAM = 20;
        public static final int MAX_SHINGLE_SIZE = 3;
    }
}

