/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.analysis;

import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.AnalysisMode;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.AnalyzerComponents;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.CharFilterFactory;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.CustomAnalyzer;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.ReloadableCustomAnalyzer;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.TokenFilterFactory;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.TokenizerFactory;

public class CustomAnalyzerProvider
extends AbstractIndexAnalyzerProvider<Analyzer> {
    private final Settings analyzerSettings;
    private Analyzer customAnalyzer;

    public CustomAnalyzerProvider(IndexSettings indexSettings, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.analyzerSettings = settings;
    }

    void build(Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        this.customAnalyzer = CustomAnalyzerProvider.create(this.name(), this.analyzerSettings, tokenizers, charFilters, tokenFilters);
    }

    private static Analyzer create(String name, Settings analyzerSettings, Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        int positionIncrementGap = 100;
        positionIncrementGap = analyzerSettings.getAsInt("position_increment_gap", positionIncrementGap);
        int offsetGap = analyzerSettings.getAsInt("offset_gap", -1);
        AnalyzerComponents components = AnalyzerComponents.createComponents(name, analyzerSettings, tokenizers, charFilters, tokenFilters);
        if (components.analysisMode().equals((Object)AnalysisMode.SEARCH_TIME)) {
            return new ReloadableCustomAnalyzer(components, positionIncrementGap, offsetGap);
        }
        return new CustomAnalyzer(components.getTokenizerFactory(), components.getCharFilters(), components.getTokenFilters(), positionIncrementGap, offsetGap);
    }

    @Override
    public Analyzer get() {
        return this.customAnalyzer;
    }
}

