/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.index.ShardIndexingPressureSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.ShardIndexingPressureTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;

public class ShardIndexingPressureStore {
    public static final Setting<Integer> MAX_COLD_STORE_SIZE = Setting.intSetting("shard_indexing_pressure.cache_store.max_size", 200, 100, 1000, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final Map<ShardId, ShardIndexingPressureTracker> shardIndexingPressureHotStore = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private final Map<ShardId, ShardIndexingPressureTracker> shardIndexingPressureColdStore = new HashMap<ShardId, ShardIndexingPressureTracker>();
    private final ShardIndexingPressureSettings shardIndexingPressureSettings;
    private volatile int maxColdStoreSize;

    public ShardIndexingPressureStore(ShardIndexingPressureSettings shardIndexingPressureSettings, ClusterSettings clusterSettings, Settings settings) {
        this.shardIndexingPressureSettings = shardIndexingPressureSettings;
        this.maxColdStoreSize = MAX_COLD_STORE_SIZE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MAX_COLD_STORE_SIZE, this::setMaxColdStoreSize);
    }

    public ShardIndexingPressureTracker getShardIndexingPressureTracker(ShardId shardId) {
        ShardIndexingPressureTracker tracker = this.shardIndexingPressureHotStore.get(shardId);
        if (Objects.isNull(tracker)) {
            tracker = this.shardIndexingPressureColdStore.get(shardId);
            if (Objects.isNull(tracker)) {
                tracker = this.shardIndexingPressureHotStore.computeIfAbsent(shardId, k -> new ShardIndexingPressureTracker(shardId, this.shardIndexingPressureSettings.getShardPrimaryAndCoordinatingBaseLimits(), this.shardIndexingPressureSettings.getShardReplicaBaseLimits()));
                this.updateShardIndexingPressureColdStore(tracker);
            } else {
                ShardIndexingPressureTracker newTracker = this.shardIndexingPressureHotStore.putIfAbsent(shardId, tracker);
                tracker = newTracker == null ? tracker : newTracker;
            }
        }
        return tracker;
    }

    public Map<ShardId, ShardIndexingPressureTracker> getShardIndexingPressureHotStore() {
        return Collections.unmodifiableMap(this.shardIndexingPressureHotStore);
    }

    public Map<ShardId, ShardIndexingPressureTracker> getShardIndexingPressureColdStore() {
        return Collections.unmodifiableMap(this.shardIndexingPressureColdStore);
    }

    public void tryTrackerCleanupFromHotStore(ShardIndexingPressureTracker tracker, BooleanSupplier condition) {
        if (condition.getAsBoolean()) {
            this.shardIndexingPressureColdStore.putIfAbsent(tracker.getShardId(), tracker);
            this.shardIndexingPressureHotStore.remove(tracker.getShardId(), tracker);
        }
    }

    private void updateShardIndexingPressureColdStore(ShardIndexingPressureTracker tracker) {
        if (this.shardIndexingPressureColdStore.size() > this.maxColdStoreSize) {
            this.shardIndexingPressureColdStore.clear();
        }
        this.shardIndexingPressureColdStore.put(tracker.getShardId(), tracker);
    }

    private void setMaxColdStoreSize(int maxColdStoreSize) {
        this.maxColdStoreSize = maxColdStoreSize;
    }
}

