/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FilterMergePolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergePolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentCommitInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.TieredMergePolicy;

final class OpenSearchTieredMergePolicy
extends FilterMergePolicy {
    final TieredMergePolicy regularMergePolicy;
    final TieredMergePolicy forcedMergePolicy;

    OpenSearchTieredMergePolicy() {
        super(new TieredMergePolicy());
        this.regularMergePolicy = (TieredMergePolicy)this.in;
        this.forcedMergePolicy = new TieredMergePolicy();
        this.forcedMergePolicy.setMaxMergedSegmentMB(Double.POSITIVE_INFINITY);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos infos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.forcedMergePolicy.findForcedMerges(infos, maxSegmentCount, segmentsToMerge, mergeContext);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos infos, MergePolicy.MergeContext mergeContext) throws IOException {
        return this.forcedMergePolicy.findForcedDeletesMerges(infos, mergeContext);
    }

    public void setForceMergeDeletesPctAllowed(double forceMergeDeletesPctAllowed) {
        this.regularMergePolicy.setForceMergeDeletesPctAllowed(forceMergeDeletesPctAllowed);
        this.forcedMergePolicy.setForceMergeDeletesPctAllowed(forceMergeDeletesPctAllowed);
    }

    public double getForceMergeDeletesPctAllowed() {
        return this.forcedMergePolicy.getForceMergeDeletesPctAllowed();
    }

    public void setFloorSegmentMB(double mbFrac) {
        this.regularMergePolicy.setFloorSegmentMB(mbFrac);
        this.forcedMergePolicy.setFloorSegmentMB(mbFrac);
    }

    public double getFloorSegmentMB() {
        return this.regularMergePolicy.getFloorSegmentMB();
    }

    public void setMaxMergeAtOnce(int maxMergeAtOnce) {
        this.regularMergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
        this.forcedMergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
    }

    public int getMaxMergeAtOnce() {
        return this.regularMergePolicy.getMaxMergeAtOnce();
    }

    public void setMaxMergedSegmentMB(double mbFrac) {
        this.regularMergePolicy.setMaxMergedSegmentMB(mbFrac);
    }

    public double getMaxMergedSegmentMB() {
        return this.regularMergePolicy.getMaxMergedSegmentMB();
    }

    public void setSegmentsPerTier(double segmentsPerTier) {
        this.regularMergePolicy.setSegmentsPerTier(segmentsPerTier);
        this.forcedMergePolicy.setSegmentsPerTier(segmentsPerTier);
    }

    public double getSegmentsPerTier() {
        return this.regularMergePolicy.getSegmentsPerTier();
    }

    public void setDeletesPctAllowed(double deletesPctAllowed) {
        this.regularMergePolicy.setDeletesPctAllowed(deletesPctAllowed);
        this.forcedMergePolicy.setDeletesPctAllowed(deletesPctAllowed);
    }

    public double getDeletesPctAllowed() {
        return this.regularMergePolicy.getDeletesPctAllowed();
    }
}

