/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway;

import java.util.Comparator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.index.Index;

public abstract class PriorityComparator
implements Comparator<ShardRouting> {
    @Override
    public final int compare(ShardRouting o1, ShardRouting o2) {
        String o1Index = o1.getIndexName();
        String o2Index = o2.getIndexName();
        int cmp = 0;
        if (!o1Index.equals(o2Index)) {
            IndexMetadata metadata01 = this.getMetadata(o1.index());
            IndexMetadata metadata02 = this.getMetadata(o2.index());
            cmp = Boolean.compare(metadata02.isSystem(), metadata01.isSystem());
            if (cmp == 0) {
                Settings settingsO1 = metadata01.getSettings();
                Settings settingsO2 = metadata02.getSettings();
                cmp = Long.compare(PriorityComparator.priority(settingsO2), PriorityComparator.priority(settingsO1));
                if (cmp == 0 && (cmp = Long.compare(PriorityComparator.timeCreated(settingsO2), PriorityComparator.timeCreated(settingsO1))) == 0) {
                    cmp = o2Index.compareTo(o1Index);
                }
            }
        }
        return cmp;
    }

    private static int priority(Settings settings) {
        return IndexMetadata.INDEX_PRIORITY_SETTING.get(settings);
    }

    private static long timeCreated(Settings settings) {
        return settings.getAsLong("index.creation_date", -1L);
    }

    protected abstract IndexMetadata getMetadata(Index var1);

    public static PriorityComparator getAllocationComparator(final RoutingAllocation allocation) {
        return new PriorityComparator(){

            @Override
            protected IndexMetadata getMetadata(Index index) {
                return allocation.metadata().getIndexSafe(index);
            }
        };
    }
}

