/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.NIOFSDirectory;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.store.IndexOutputOutputStream;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentFactory;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.core.internal.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.WriteStateException;

public abstract class MetadataStateFormat<T> {
    public static final XContentType FORMAT = XContentType.SMILE;
    public static final String STATE_DIR_NAME = "_state";
    public static final String STATE_FILE_EXTENSION = ".st";
    private static final String STATE_FILE_CODEC = "state";
    private static final int MIN_COMPATIBLE_STATE_FILE_VERSION = 1;
    private static final int STATE_FILE_VERSION = 1;
    private final String prefix;
    private final Pattern stateFilePattern;
    private static final Logger logger = LogManager.getLogger(MetadataStateFormat.class);

    protected MetadataStateFormat(String prefix) {
        this.prefix = prefix;
        this.stateFilePattern = Pattern.compile(Pattern.quote(prefix) + "(\\d+)(.st)?");
    }

    private static void deleteFileIfExists(Path stateLocation, Directory directory, String fileName) throws IOException {
        try {
            directory.deleteFile(fileName);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            // empty catch block
        }
        logger.trace("cleaned up {}", (Object)stateLocation.resolve(fileName));
    }

    private static void deleteFileIgnoreExceptions(Path stateLocation, Directory directory, String fileName) {
        try {
            MetadataStateFormat.deleteFileIfExists(stateLocation, directory, fileName);
        }
        catch (IOException e) {
            logger.trace("clean up failed {}", (Object)stateLocation.resolve(fileName));
        }
    }

    private void writeStateToFirstLocation(T state, Path stateLocation, Directory stateDir, String tmpFileName) throws WriteStateException {
        try {
            MetadataStateFormat.deleteFileIfExists(stateLocation, stateDir, tmpFileName);
            try (IndexOutput out = EndiannessReverserUtil.createOutput(stateDir, tmpFileName, IOContext.DEFAULT);){
                CodecUtil.writeHeader(out, STATE_FILE_CODEC, 1);
                out.writeInt(FORMAT.index());
                try (XContentBuilder builder = this.newXContentBuilder(FORMAT, new IndexOutputOutputStream(out){

                    @Override
                    public void close() {
                    }
                });){
                    builder.startObject();
                    this.toXContent(builder, state);
                    builder.endObject();
                }
                CodecUtil.writeFooter(out);
            }
            stateDir.sync(Collections.singleton(tmpFileName));
        }
        catch (Exception e) {
            throw new WriteStateException(false, "failed to write state to the first location tmp file " + stateLocation.resolve(tmpFileName), e);
        }
    }

    private static void copyStateToExtraLocations(List<Tuple<Path, Directory>> stateDirs, String tmpFileName) throws WriteStateException {
        Directory srcStateDir = stateDirs.get(0).v2();
        for (int i = 1; i < stateDirs.size(); ++i) {
            Tuple<Path, Directory> extraStatePathAndDir = stateDirs.get(i);
            Path extraStateLocation = extraStatePathAndDir.v1();
            Directory extraStateDir = extraStatePathAndDir.v2();
            try {
                MetadataStateFormat.deleteFileIfExists(extraStateLocation, extraStateDir, tmpFileName);
                extraStateDir.copyFrom(srcStateDir, tmpFileName, tmpFileName, IOContext.DEFAULT);
                extraStateDir.sync(Collections.singleton(tmpFileName));
                continue;
            }
            catch (Exception e) {
                throw new WriteStateException(false, "failed to copy tmp state file to extra location " + extraStateLocation, e);
            }
        }
    }

    private static void performRenames(String tmpFileName, String fileName, List<Tuple<Path, Directory>> stateDirectories) throws WriteStateException {
        Directory firstStateDirectory = stateDirectories.get(0).v2();
        try {
            firstStateDirectory.rename(tmpFileName, fileName);
        }
        catch (IOException e) {
            throw new WriteStateException(false, "failed to rename tmp file to final name in the first state location " + stateDirectories.get(0).v1().resolve(tmpFileName), e);
        }
        for (int i = 1; i < stateDirectories.size(); ++i) {
            Directory extraStateDirectory = stateDirectories.get(i).v2();
            try {
                extraStateDirectory.rename(tmpFileName, fileName);
                continue;
            }
            catch (IOException e) {
                throw new WriteStateException(true, "failed to rename tmp file to final name in extra state location " + stateDirectories.get(i).v1().resolve(tmpFileName), e);
            }
        }
    }

    private static void performStateDirectoriesFsync(List<Tuple<Path, Directory>> stateDirectories) throws WriteStateException {
        for (int i = 0; i < stateDirectories.size(); ++i) {
            try {
                stateDirectories.get(i).v2().syncMetaData();
                continue;
            }
            catch (IOException e) {
                throw new WriteStateException(true, "meta data directory fsync has failed " + stateDirectories.get(i).v1(), e);
            }
        }
    }

    public final long writeAndCleanup(T state, Path ... locations) throws WriteStateException {
        return this.write(state, true, locations);
    }

    public final long write(T state, Path ... locations) throws WriteStateException {
        return this.write(state, false, locations);
    }

    private long write(T state, boolean cleanup, Path ... locations) throws WriteStateException {
        long newGenerationId;
        long oldGenerationId;
        if (locations == null) {
            throw new IllegalArgumentException("Locations must not be null");
        }
        if (locations.length <= 0) {
            throw new IllegalArgumentException("One or more locations required");
        }
        try {
            oldGenerationId = this.findMaxGenerationId(this.prefix, locations);
            newGenerationId = oldGenerationId + 1L;
        }
        catch (Exception e) {
            throw new WriteStateException(false, "exception during looking up new generation id", e);
        }
        assert (newGenerationId >= 0L) : "newGenerationId must be positive but was: [" + oldGenerationId + "]";
        String fileName = this.getStateFileName(newGenerationId);
        String tmpFileName = fileName + ".tmp";
        ArrayList<Tuple<Path, Directory>> directories = new ArrayList<Tuple<Path, Directory>>();
        try {
            for (Path location : locations) {
                Path stateLocation = location.resolve(STATE_DIR_NAME);
                try {
                    directories.add(new Tuple<Path, Directory>(location, this.newDirectory(stateLocation)));
                }
                catch (IOException e) {
                    throw new WriteStateException(false, "failed to open state directory " + stateLocation, e);
                }
            }
            this.writeStateToFirstLocation(state, (Path)((Tuple)directories.get(0)).v1(), (Directory)((Tuple)directories.get(0)).v2(), tmpFileName);
            MetadataStateFormat.copyStateToExtraLocations(directories, tmpFileName);
            MetadataStateFormat.performRenames(tmpFileName, fileName, directories);
            MetadataStateFormat.performStateDirectoriesFsync(directories);
        }
        catch (WriteStateException e) {
            if (cleanup) {
                this.cleanupOldFiles(oldGenerationId, locations);
            }
            throw e;
        }
        finally {
            for (Tuple tuple : directories) {
                MetadataStateFormat.deleteFileIgnoreExceptions((Path)tuple.v1(), (Directory)tuple.v2(), tmpFileName);
                IOUtils.closeWhileHandlingException((Closeable)tuple.v2());
            }
        }
        if (cleanup) {
            this.cleanupOldFiles(newGenerationId, locations);
        }
        return newGenerationId;
    }

    protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
        return XContentFactory.contentBuilder(type, stream);
    }

    public abstract void toXContent(XContentBuilder var1, T var2) throws IOException;

    public abstract T fromXContent(XContentParser var1) throws IOException;

    /*
     * Exception decompiling
     */
    public final T read(NamedXContentRegistry namedXContentRegistry, Path file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Directory newDirectory(Path dir) throws IOException {
        return new NIOFSDirectory(dir);
    }

    public void cleanupOldFiles(long currentGeneration, Path[] locations) {
        String fileNameToKeep = this.getStateFileName(currentGeneration);
        for (Path location : locations) {
            logger.trace("cleanupOldFiles: cleaning up {}", (Object)location);
            Path stateLocation = location.resolve(STATE_DIR_NAME);
            try (Directory stateDir = this.newDirectory(stateLocation);){
                for (String file : stateDir.listAll()) {
                    if (!file.startsWith(this.prefix) || file.equals(fileNameToKeep)) continue;
                    MetadataStateFormat.deleteFileIgnoreExceptions(stateLocation, stateDir, file);
                }
            }
            catch (Exception e) {
                logger.trace("clean up failed for state location {}", (Object)stateLocation);
            }
        }
    }

    private long findMaxGenerationId(String prefix, Path ... locations) throws IOException {
        long maxId = -1L;
        for (Path dataLocation : locations) {
            Path resolve = dataLocation.resolve(STATE_DIR_NAME);
            if (!Files.exists(resolve, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(resolve, prefix + "*");){
                for (Path stateFile : stream) {
                    Matcher matcher = this.stateFilePattern.matcher(stateFile.getFileName().toString());
                    if (!matcher.matches()) continue;
                    long id = Long.parseLong(matcher.group(1));
                    maxId = Math.max(maxId, id);
                }
            }
        }
        return maxId;
    }

    private List<Path> findStateFilesByGeneration(long generation, Path ... locations) {
        ArrayList<Path> files = new ArrayList<Path>();
        if (generation == -1L) {
            return files;
        }
        String fileName = this.getStateFileName(generation);
        for (Path dataLocation : locations) {
            Path stateFilePath = dataLocation.resolve(STATE_DIR_NAME).resolve(fileName);
            if (!Files.exists(stateFilePath, new LinkOption[0])) continue;
            logger.trace("found state file: {}", (Object)stateFilePath);
            files.add(stateFilePath);
        }
        return files;
    }

    public String getStateFileName(long generation) {
        return this.prefix + generation + STATE_FILE_EXTENSION;
    }

    public T loadGeneration(Logger logger, NamedXContentRegistry namedXContentRegistry, long generation, Path ... dataLocations) {
        List<Path> stateFiles = this.findStateFilesByGeneration(generation, dataLocations);
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Path stateFile : stateFiles) {
            try {
                T state = this.read(namedXContentRegistry, stateFile);
                logger.trace("generation id [{}] read from [{}]", (Object)generation, (Object)stateFile.getFileName());
                return state;
            }
            catch (Exception e) {
                exceptions.add(new IOException("failed to read " + stateFile, e));
                logger.debug(() -> new ParameterizedMessage("{}: failed to read [{}], ignoring...", (Object)stateFile, (Object)this.prefix), (Throwable)e);
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
        if (stateFiles.size() > 0) {
            throw new IllegalStateException("Could not find a state file to recover from among " + stateFiles.stream().map(Object::toString).collect(Collectors.joining(", ")));
        }
        return null;
    }

    public Tuple<T, Long> loadLatestStateWithGeneration(Logger logger, NamedXContentRegistry namedXContentRegistry, Path ... dataLocations) throws IOException {
        long generation = this.findMaxGenerationId(this.prefix, dataLocations);
        T state = this.loadGeneration(logger, namedXContentRegistry, generation, dataLocations);
        if (generation > -1L && state == null) {
            throw new IllegalStateException("unable to find state files with generation id " + generation + " returned by findMaxGenerationId function, in data folders [" + Arrays.stream(dataLocations).map(Object::toString).collect(Collectors.joining(", ")) + "], concurrent writes?");
        }
        return Tuple.tuple(state, generation);
    }

    public T loadLatestState(Logger logger, NamedXContentRegistry namedXContentRegistry, Path ... dataLocations) throws IOException {
        return this.loadLatestStateWithGeneration(logger, namedXContentRegistry, dataLocations).v1();
    }

    public static void deleteMetaState(Path ... dataLocations) throws IOException {
        Path[] stateDirectories = new Path[dataLocations.length];
        for (int i = 0; i < dataLocations.length; ++i) {
            stateDirectories[i] = dataLocations[i].resolve(STATE_DIR_NAME);
        }
        IOUtils.rm(stateDirectories);
    }

    public String getPrefix() {
        return this.prefix;
    }
}

