/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoShapeType;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.XShapeCollection;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.CircleBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.EnvelopeBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.LineStringBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.MultiLineStringBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.MultiPointBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.MultiPolygonBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.PointBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.PolygonBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.ShapeBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.parsers.ShapeParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Geometry;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.GeometryCollection;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;

public class GeometryCollectionBuilder
extends ShapeBuilder<Shape, GeometryCollection<Geometry>, GeometryCollectionBuilder> {
    public static final GeoShapeType TYPE = GeoShapeType.GEOMETRYCOLLECTION;
    final List<ShapeBuilder> shapes = new ArrayList<ShapeBuilder>();

    public GeometryCollectionBuilder() {
    }

    public GeometryCollectionBuilder(StreamInput in) throws IOException {
        int shapes = in.readVInt();
        for (int i = 0; i < shapes; ++i) {
            this.shape(in.readNamedWriteable(ShapeBuilder.class));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.shapes.size());
        for (ShapeBuilder shape : this.shapes) {
            out.writeNamedWriteable(shape);
        }
    }

    public GeometryCollectionBuilder shape(ShapeBuilder shape) {
        this.shapes.add(shape);
        return this;
    }

    public GeometryCollectionBuilder point(PointBuilder point) {
        this.shapes.add(point);
        return this;
    }

    public GeometryCollectionBuilder multiPoint(MultiPointBuilder multiPoint) {
        this.shapes.add(multiPoint);
        return this;
    }

    public GeometryCollectionBuilder line(LineStringBuilder line) {
        this.shapes.add(line);
        return this;
    }

    public GeometryCollectionBuilder multiLine(MultiLineStringBuilder multiLine) {
        this.shapes.add(multiLine);
        return this;
    }

    public GeometryCollectionBuilder polygon(PolygonBuilder polygon) {
        this.shapes.add(polygon);
        return this;
    }

    public GeometryCollectionBuilder multiPolygon(MultiPolygonBuilder multiPolygon) {
        this.shapes.add(multiPolygon);
        return this;
    }

    public GeometryCollectionBuilder envelope(EnvelopeBuilder envelope) {
        this.shapes.add(envelope);
        return this;
    }

    public GeometryCollectionBuilder circle(CircleBuilder circle) {
        this.shapes.add(circle);
        return this;
    }

    public ShapeBuilder getShapeAt(int i) {
        if (i >= this.shapes.size() || i < 0) {
            throw new OpenSearchException("GeometryCollection contains " + this.shapes.size() + " shapes. + No shape found at index " + i, new Object[0]);
        }
        return this.shapes.get(i);
    }

    public int numShapes() {
        return this.shapes.size();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ShapeParser.FIELD_TYPE.getPreferredName(), TYPE.shapeName());
        builder.startArray(ShapeParser.FIELD_GEOMETRIES.getPreferredName());
        for (ShapeBuilder shape : this.shapes) {
            shape.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }

    @Override
    protected StringBuilder contentToWKT() {
        StringBuilder sb = new StringBuilder();
        if (this.shapes.isEmpty()) {
            sb.append("EMPTY");
        } else {
            sb.append("(");
            sb.append(this.shapes.get(0).toWKT());
            for (int i = 1; i < this.shapes.size(); ++i) {
                sb.append(",");
                sb.append(this.shapes.get(i).toWKT());
            }
            sb.append(")");
        }
        return sb;
    }

    @Override
    public GeoShapeType type() {
        return TYPE;
    }

    @Override
    public int numDimensions() {
        if (this.shapes == null || this.shapes.isEmpty()) {
            throw new IllegalStateException("unable to get number of dimensions, GeometryCollection has not yet been initialized");
        }
        return this.shapes.get(0).numDimensions();
    }

    @Override
    public Shape buildS4J() {
        ArrayList shapes = new ArrayList(this.shapes.size());
        for (ShapeBuilder shape : this.shapes) {
            shapes.add(shape.buildS4J());
        }
        if (shapes.size() == 1) {
            return (Shape)shapes.get(0);
        }
        return new XShapeCollection(shapes, (SpatialContext)SPATIAL_CONTEXT);
    }

    @Override
    public GeometryCollection<Geometry> buildGeometry() {
        if (this.shapes.isEmpty()) {
            return GeometryCollection.EMPTY;
        }
        ArrayList shapes = new ArrayList(this.shapes.size());
        for (ShapeBuilder shape : this.shapes) {
            shapes.add(shape.buildGeometry());
        }
        return new GeometryCollection<Geometry>(shapes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.shapes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeometryCollectionBuilder other = (GeometryCollectionBuilder)obj;
        return Objects.equals(this.shapes, other.shapes);
    }
}

