/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider;

import org.graylog.shaded.opensearch2.org.opensearch.cluster.RestoreInProgress;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RecoverySource;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.Decision;

public class RestoreInProgressAllocationDecider
extends AllocationDecider {
    public static final String NAME = "restore_in_progress";

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        RestoreInProgress.ShardRestoreStatus shardRestoreStatus;
        RestoreInProgress.Entry restoreInProgress;
        RecoverySource recoverySource = shardRouting.recoverySource();
        if (recoverySource == null || recoverySource.getType() != RecoverySource.Type.SNAPSHOT) {
            return allocation.decision(Decision.YES, NAME, "ignored as shard is not being recovered from a snapshot", new Object[0]);
        }
        RecoverySource.SnapshotRecoverySource source = (RecoverySource.SnapshotRecoverySource)recoverySource;
        if (source.restoreUUID().equals("_no_api_")) {
            return allocation.decision(Decision.YES, NAME, "not an API-level restore", new Object[0]);
        }
        RestoreInProgress restoresInProgress = (RestoreInProgress)allocation.custom("restore");
        if (restoresInProgress != null && (restoreInProgress = restoresInProgress.get(source.restoreUUID())) != null && (shardRestoreStatus = restoreInProgress.shards().get(shardRouting.shardId())) != null && !shardRestoreStatus.state().completed()) {
            assert (shardRestoreStatus.state() != RestoreInProgress.State.SUCCESS) : "expected shard [" + shardRouting + "] to be in initializing state but got [" + shardRestoreStatus.state() + "]";
            return allocation.decision(Decision.YES, NAME, "shard is currently being restored", new Object[0]);
        }
        return allocation.decision(Decision.NO, NAME, "shard has failed to be restored from the snapshot [%s] because of [%s] - manually close or delete the index [%s] in order to retry to restore the snapshot again or use the reroute API to force the allocation of an empty primary shard", source.snapshot(), shardRouting.unassignedInfo().getDetails(), shardRouting.getIndexName());
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + shardRouting;
        return this.canAllocate(shardRouting, node, allocation);
    }
}

