/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexAbstraction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.regex.Regex;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexNotFoundException;

public class IndexAbstractionResolver {
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public IndexAbstractionResolver(IndexNameExpressionResolver indexNameExpressionResolver) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public List<String> resolveIndexAbstractions(String[] indices, IndicesOptions indicesOptions, Metadata metadata, boolean includeDataStreams) {
        return this.resolveIndexAbstractions(Arrays.asList(indices), indicesOptions, metadata, includeDataStreams);
    }

    public List<String> resolveIndexAbstractions(Iterable<String> indices, IndicesOptions indicesOptions, Metadata metadata, boolean includeDataStreams) {
        boolean replaceWildcards = indicesOptions.expandWildcardsOpen() || indicesOptions.expandWildcardsClosed();
        Set<String> availableIndexAbstractions = metadata.getIndicesLookup().keySet();
        return this.resolveIndexAbstractions(indices, indicesOptions, metadata, availableIndexAbstractions, replaceWildcards, includeDataStreams);
    }

    public List<String> resolveIndexAbstractions(Iterable<String> indices, IndicesOptions indicesOptions, Metadata metadata, Collection<String> availableIndexAbstractions, boolean replaceWildcards, boolean includeDataStreams) {
        ArrayList<String> finalIndices = new ArrayList<String>();
        boolean wildcardSeen = false;
        for (String index : indices) {
            String indexAbstraction;
            boolean minus = false;
            if (index.charAt(0) == '-' && wildcardSeen) {
                indexAbstraction = index.substring(1);
                minus = true;
            } else {
                indexAbstraction = index;
            }
            String dateMathName = this.indexNameExpressionResolver.resolveDateMathExpression(indexAbstraction);
            if (dateMathName != indexAbstraction) {
                assert (!dateMathName.equals(indexAbstraction));
                if (replaceWildcards && Regex.isSimpleMatchPattern(dateMathName)) {
                    indexAbstraction = dateMathName;
                } else if (availableIndexAbstractions.contains(dateMathName) && IndexAbstractionResolver.isIndexVisible(indexAbstraction, dateMathName, indicesOptions, metadata, includeDataStreams, true)) {
                    if (minus) {
                        finalIndices.remove(dateMathName);
                    } else {
                        finalIndices.add(dateMathName);
                    }
                } else if (!indicesOptions.ignoreUnavailable()) {
                    throw new IndexNotFoundException(dateMathName);
                }
            }
            if (replaceWildcards && Regex.isSimpleMatchPattern(indexAbstraction)) {
                wildcardSeen = true;
                HashSet<String> resolvedIndices = new HashSet<String>();
                for (String authorizedIndex : availableIndexAbstractions) {
                    if (!Regex.simpleMatch(indexAbstraction, authorizedIndex) || !IndexAbstractionResolver.isIndexVisible(indexAbstraction, authorizedIndex, indicesOptions, metadata, includeDataStreams)) continue;
                    resolvedIndices.add(authorizedIndex);
                }
                if (resolvedIndices.isEmpty()) {
                    if (indicesOptions.allowNoIndices()) continue;
                    throw new IndexNotFoundException(indexAbstraction);
                }
                if (minus) {
                    finalIndices.removeAll(resolvedIndices);
                    continue;
                }
                finalIndices.addAll(resolvedIndices);
                continue;
            }
            if (!dateMathName.equals(indexAbstraction)) continue;
            if (minus) {
                finalIndices.remove(indexAbstraction);
                continue;
            }
            finalIndices.add(indexAbstraction);
        }
        return finalIndices;
    }

    public static boolean isIndexVisible(String expression, String index, IndicesOptions indicesOptions, Metadata metadata, boolean includeDataStreams) {
        return IndexAbstractionResolver.isIndexVisible(expression, index, indicesOptions, metadata, includeDataStreams, false);
    }

    public static boolean isIndexVisible(String expression, String index, IndicesOptions indicesOptions, Metadata metadata, boolean includeDataStreams, boolean dateMathExpression) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(index);
        if (indexAbstraction == null) {
            throw new IllegalStateException("could not resolve index abstraction [" + index + "]");
        }
        boolean isHidden = indexAbstraction.isHidden();
        if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS) {
            if (indicesOptions.ignoreAliases()) {
                return false;
            }
            return !isHidden || indicesOptions.expandWildcardsHidden() || IndexAbstractionResolver.isVisibleDueToImplicitHidden(expression, index);
        }
        if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM) {
            return includeDataStreams;
        }
        assert (indexAbstraction.getIndices().size() == 1) : "concrete index must point to a single index";
        if (dateMathExpression) {
            assert (IndexMetadata.State.values().length == 2) : "a new IndexMetadata.State value may need to be handled!";
            return true;
        }
        if (isHidden && !indicesOptions.expandWildcardsHidden() && !IndexAbstractionResolver.isVisibleDueToImplicitHidden(expression, index)) {
            return false;
        }
        IndexMetadata indexMetadata = indexAbstraction.getIndices().get(0);
        if (indexMetadata.getState() == IndexMetadata.State.CLOSE && indicesOptions.expandWildcardsClosed()) {
            return true;
        }
        return indexMetadata.getState() == IndexMetadata.State.OPEN && indicesOptions.expandWildcardsOpen();
    }

    private static boolean isVisibleDueToImplicitHidden(String expression, String index) {
        return index.startsWith(".") && expression.startsWith(".") && Regex.isSimpleMatchPattern(expression);
    }
}

