/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.client.tasks.TaskInfo;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ObjectParser;

class NodeData {
    private String nodeId;
    private String name;
    private String transportAddress;
    private String host;
    private String ip;
    private final List<String> roles = new ArrayList<String>();
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<TaskInfo> tasks = new ArrayList<TaskInfo>();
    public static final ObjectParser.NamedObjectParser<NodeData, Void> PARSER;

    NodeData(String nodeId) {
        this.nodeId = nodeId;
    }

    void setName(String name) {
        this.name = name;
    }

    public void setAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    void setTransportAddress(String transportAddress) {
        this.transportAddress = transportAddress;
    }

    void setHost(String host) {
        this.host = host;
    }

    void setIp(String ip) {
        this.ip = ip;
    }

    void setRoles(List<String> roles) {
        if (roles != null) {
            this.roles.addAll(roles);
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getName() {
        return this.name;
    }

    public String getTransportAddress() {
        return this.transportAddress;
    }

    public String getHost() {
        return this.host;
    }

    public String getIp() {
        return this.ip;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    void setTasks(List<TaskInfo> tasks) {
        if (tasks != null) {
            this.tasks.addAll(tasks);
        }
    }

    public String toString() {
        return "NodeData{nodeId='" + this.nodeId + "', name='" + this.name + "', transportAddress='" + this.transportAddress + "', host='" + this.host + "', ip='" + this.ip + "', roles=" + this.roles + ", attributes=" + this.attributes + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeData)) {
            return false;
        }
        NodeData nodeData = (NodeData)o;
        return Objects.equals(this.getNodeId(), nodeData.getNodeId()) && Objects.equals(this.getName(), nodeData.getName()) && Objects.equals(this.getTransportAddress(), nodeData.getTransportAddress()) && Objects.equals(this.getHost(), nodeData.getHost()) && Objects.equals(this.getIp(), nodeData.getIp()) && Objects.equals(this.getRoles(), nodeData.getRoles()) && Objects.equals(this.getAttributes(), nodeData.getAttributes()) && Objects.equals(this.getTasks(), nodeData.getTasks());
    }

    public int hashCode() {
        return Objects.hash(this.getNodeId(), this.getName(), this.getTransportAddress(), this.getHost(), this.getIp(), this.getRoles(), this.getAttributes(), this.getTasks());
    }

    static {
        ObjectParser<NodeData, Void> parser = new ObjectParser<NodeData, Void>("nodes");
        parser.declareString(NodeData::setName, new ParseField("name", new String[0]));
        parser.declareString(NodeData::setTransportAddress, new ParseField("transport_address", new String[0]));
        parser.declareString(NodeData::setHost, new ParseField("host", new String[0]));
        parser.declareString(NodeData::setIp, new ParseField("ip", new String[0]));
        parser.declareStringArray(NodeData::setRoles, new ParseField("roles", new String[0]));
        parser.declareField(NodeData::setAttributes, (p, c) -> p.mapStrings(), new ParseField("attributes", new String[0]), ObjectParser.ValueType.OBJECT);
        parser.declareNamedObjects(NodeData::setTasks, TaskInfo.PARSER, new ParseField("tasks", new String[0]));
        PARSER = (p, v, nodeId) -> parser.parse(p, new NodeData(nodeId), null);
    }
}

