/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.DeletePipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.GetPipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.PutPipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.SimulatePipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.client.Request;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestConverters;

final class IngestRequestConverters {
    private IngestRequestConverters() {
    }

    static Request getPipeline(GetPipelineRequest getPipelineRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ingest/pipeline").addCommaSeparatedPathParts(getPipelineRequest.getIds()).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withMasterTimeout(getPipelineRequest.masterNodeTimeout());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request putPipeline(PutPipelineRequest putPipelineRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ingest/pipeline").addPathPart(putPipelineRequest.getId()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withTimeout(putPipelineRequest.timeout());
        parameters.withMasterTimeout(putPipelineRequest.masterNodeTimeout());
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConverters.createEntity(putPipelineRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ingest/pipeline").addPathPart(deletePipelineRequest.getId()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withTimeout(deletePipelineRequest.timeout());
        parameters.withMasterTimeout(deletePipelineRequest.masterNodeTimeout());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request simulatePipeline(SimulatePipelineRequest simulatePipelineRequest) throws IOException {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ingest/pipeline");
        if (simulatePipelineRequest.getId() != null && !simulatePipelineRequest.getId().isEmpty()) {
            builder.addPathPart(simulatePipelineRequest.getId());
        }
        builder.addPathPartAsIs("_simulate");
        String endpoint = builder.build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.putParam("verbose", Boolean.toString(simulatePipelineRequest.isVerbose()));
        request.addParameters(params.asMap());
        request.setEntity(RequestConverters.createEntity(simulatePipelineRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }
}

