/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.bootstrap;

import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.ConsoleCtrlHandler;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.JNANatives;

final class Natives {
    private static final Logger logger = LogManager.getLogger(Natives.class);
    static final boolean JNA_AVAILABLE;

    private Natives() {
    }

    static void tryMlockall() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot mlockall because JNA is not available");
            return;
        }
        JNANatives.tryMlockall();
    }

    static boolean definitelyRunningAsRoot() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot check if running as root because JNA is not available");
            return false;
        }
        return JNANatives.definitelyRunningAsRoot();
    }

    static void tryVirtualLock() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot virtual lock because JNA is not available");
            return;
        }
        JNANatives.tryVirtualLock();
    }

    static String getShortPathName(String path) {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot obtain short path for [{}] because JNA is not available", (Object)path);
            return path;
        }
        return JNANatives.getShortPathName(path);
    }

    static void addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot register console handler because JNA is not available");
            return;
        }
        JNANatives.addConsoleCtrlHandler(handler);
    }

    static boolean isMemoryLocked() {
        if (!JNA_AVAILABLE) {
            return false;
        }
        return JNANatives.LOCAL_MLOCKALL;
    }

    static void tryInstallSystemCallFilter(Path tmpFile) {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot install system call filter because JNA is not available");
            return;
        }
        JNANatives.tryInstallSystemCallFilter(tmpFile);
    }

    static void trySetMaxNumberOfThreads() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot getrlimit RLIMIT_NPROC because JNA is not available");
            return;
        }
        JNANatives.trySetMaxNumberOfThreads();
    }

    static void trySetMaxSizeVirtualMemory() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot getrlimit RLIMIT_AS because JNA is not available");
            return;
        }
        JNANatives.trySetMaxSizeVirtualMemory();
    }

    static void trySetMaxFileSize() {
        if (!JNA_AVAILABLE) {
            logger.warn("cannot getrlimit RLIMIT_FSIZE because JNA is not available");
            return;
        }
        JNANatives.trySetMaxFileSize();
    }

    static boolean isSystemCallFilterInstalled() {
        if (!JNA_AVAILABLE) {
            return false;
        }
        return JNANatives.LOCAL_SYSTEM_CALL_FILTER;
    }

    static {
        boolean v = false;
        try {
            Class.forName("org.graylog.shaded.opensearch2.com.sun.jna.Native");
            v = true;
        }
        catch (ClassNotFoundException e) {
            logger.warn("JNA not found. native methods will be disabled.", (Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("unable to load JNA native support library, native methods will be disabled.", (Throwable)e);
        }
        JNA_AVAILABLE = v;
    }
}

