/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.bootstrap;

import java.io.FilePermission;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Permissions;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.Security;
import org.graylog.shaded.opensearch2.org.opensearch.common.SuppressForbidden;

public class FilePermissionUtils {
    private FilePermissionUtils() {
    }

    @SuppressForbidden(reason="only place where creating Java-9 compatible FilePermission objects is possible")
    public static void addSingleFilePath(Permissions policy, Path path, String permissions) throws IOException {
        policy.add(new FilePermission(path.toString(), permissions));
        if (Files.exists(path, new LinkOption[0])) {
            Path realPath = path.toRealPath(new LinkOption[0]);
            if (!path.toString().equals(realPath.toString())) {
                policy.add(new FilePermission(realPath.toString(), permissions));
            }
        }
    }

    @SuppressForbidden(reason="only place where creating Java-9 compatible FilePermission objects is possible")
    public static void addDirectoryPath(Permissions policy, String configurationName, Path path, String permissions, boolean recursiveAccessOnly) throws IOException {
        try {
            Security.ensureDirectoryExists(path);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to access '" + configurationName + "' (" + path + ")", e);
        }
        if (!recursiveAccessOnly) {
            policy.add(new FilePermission(path.toString(), permissions));
        }
        policy.add(new FilePermission(path.toString() + path.getFileSystem().getSeparator() + "-", permissions));
        Path realPath = path.toRealPath(new LinkOption[0]);
        if (!path.toString().equals(realPath.toString())) {
            if (!recursiveAccessOnly) {
                policy.add(new FilePermission(realPath.toString(), permissions));
            }
            policy.add(new FilePermission(realPath.toString() + realPath.getFileSystem().getSeparator() + "-", permissions));
        }
    }
}

