/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.support.broadcast;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.action.IndicesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.OriginalIndices;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.broadcast.BroadcastRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;

public abstract class BroadcastShardRequest
extends TransportRequest
implements IndicesRequest {
    private ShardId shardId;
    protected OriginalIndices originalIndices;

    protected BroadcastShardRequest() {
    }

    public BroadcastShardRequest(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    protected BroadcastShardRequest(ShardId shardId, BroadcastRequest<? extends BroadcastRequest<?>> request) {
        this.shardId = shardId;
        this.originalIndices = new OriginalIndices(request);
    }

    protected BroadcastShardRequest(ShardId shardId, OriginalIndices originalIndices) {
        this.shardId = shardId;
        this.originalIndices = originalIndices;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }
}

