/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.get;

import java.io.IOException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.GetResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.MultiGetRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.MultiGetResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.MultiGetShardRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.MultiGetShardResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.TransportActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.single.shard.TransportSingleShardAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardIterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexService;
import org.graylog.shaded.opensearch2.org.opensearch.index.get.GetResult;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportShardMultiGetAction
extends TransportSingleShardAction<MultiGetShardRequest, MultiGetShardResponse> {
    private static final String ACTION_NAME = "indices:data/read/mget[shard]";
    private final IndicesService indicesService;

    @Inject
    public TransportShardMultiGetAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, MultiGetShardRequest::new, "get");
        this.indicesService = indicesService;
    }

    @Override
    protected boolean isSubAction() {
        return true;
    }

    @Override
    protected Writeable.Reader<MultiGetShardResponse> getResponseReader() {
        return MultiGetShardResponse::new;
    }

    @Override
    protected boolean resolveIndex(MultiGetShardRequest request) {
        return true;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(state, ((MultiGetShardRequest)request.request()).index(), ((MultiGetShardRequest)request.request()).shardId(), ((MultiGetShardRequest)request.request()).preference());
    }

    @Override
    protected void asyncShardOperation(MultiGetShardRequest request, ShardId shardId, ActionListener<MultiGetShardResponse> listener) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.realtime()) {
            super.asyncShardOperation(request, shardId, listener);
        } else {
            indexShard.awaitShardSearchActive(b -> {
                try {
                    super.asyncShardOperation(request, shardId, listener);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
    }

    @Override
    protected MultiGetShardResponse shardOperation(MultiGetShardRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.refresh() && !request.realtime()) {
            indexShard.refresh("refresh_flag_mget");
        }
        MultiGetShardResponse response = new MultiGetShardResponse();
        for (int i = 0; i < request.locations.size(); ++i) {
            MultiGetRequest.Item item = request.items.get(i);
            try {
                GetResult getResult = indexShard.getService().get(item.id(), item.storedFields(), request.realtime(), item.version(), item.versionType(), item.fetchSourceContext());
                response.add(request.locations.get(i), new GetResponse(getResult));
                continue;
            }
            catch (RuntimeException e) {
                if (TransportActions.isShardNotAvailableException(e)) {
                    throw e;
                }
                this.logger.debug(() -> new ParameterizedMessage("{} failed to execute multi_get for [{}]", (Object)shardId, (Object)item.id()), (Throwable)e);
                response.add(request.locations.get(i), new MultiGetResponse.Failure(request.index(), item.id(), e));
            }
        }
        return response;
    }

    @Override
    protected String getExecutor(MultiGetShardRequest request, ShardId shardId) {
        ClusterState clusterState = this.clusterService.state();
        if (clusterState.metadata().index(shardId.getIndex()).isSystem()) {
            return "system_read";
        }
        if (this.indicesService.indexServiceSafe(shardId.getIndex()).getIndexSettings().isSearchThrottled()) {
            return "search_throttled";
        }
        return super.getExecutor(request, shardId);
    }
}

